package com.nerjal.bettermaps;

import mc.recraftors.unruled_api.UnruledApi;
import mc.recraftors.unruled_api.impl.BoundedIntRuleValidatorAdapter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928.class_4310;
import net.minecraft.class_1928.class_4312;
import net.minecraft.class_1928.class_4313;
import net.minecraft.class_1928.class_5198;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.class_9428;
import net.minecraft.world.GameRules.*;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import static net.minecraft.class_9334.field_49628;
import static net.minecraft.class_9334.field_49632;

public final class Bettermaps {
    public static final Map<String, LocateTask> locateMapTaskThreads = new LinkedHashMap<>();
    public static final AtomicInteger taskCounter = new AtomicInteger();
    public static final Lock mapTaskSafeLock = new ReentrantLock();
    public static final Lock mapTaskStepLock = new ReentrantLock(true);
    private static int permits = 16;
    private static final AtomicInteger availablePermits = new AtomicInteger(permits);
    private static Semaphore mapTaskMaxSemaphore = new Semaphore(permits, true);

    public static final String MOD_ID = "bettermaps";

    private static final String DO_BETTERMAPS_KEY = "doBetterMaps";
    private static final String DO_BETTERMAPS_LOOT_KEY = "doBetterMapsLoot";
    private static final String DO_BETTERMAPS_TRADE_KEY = "doBetterMapsTrades";
    private static final String DO_BETTERMAP_FROM_PLAYER_POS_KEY = "doBetterMapFromPlayerPos";
    private static final String DO_BETTERMAP_DYNAMIC_LOCATING_KEY = "doBetterMapsDynamicLocating";
    private static final String DO_BETTERMAPS_FEEDBACK_KEY = "doBetterMapsFeedback";
    private static final String BETTERMAPS_MAX_TASKS_KEY = "betterMapsMaxTasks";
    private static final String BETTERMAPS_QUEUE_TASKS_KEY = "doBetterMapsTaskQueue";

    public static final class_4313<class_4310> DO_BETTERMAPS = UnruledApi.registerBoolean(DO_BETTERMAPS_KEY, class_5198.field_24094, true);
    public static final class_4313<class_4310> DO_BETTERMAPS_LOOT = UnruledApi.registerBoolean(DO_BETTERMAPS_LOOT_KEY, class_5198.field_24097, true);
    public static final class_4313<class_4310> DO_BETTERMAPS_TRADE = UnruledApi.registerBoolean(DO_BETTERMAPS_TRADE_KEY, class_5198.field_24095, true);
    public static final class_4313<class_4310> DO_BETTERMAP_FROM_PLAYER_POS = UnruledApi.registerBoolean(DO_BETTERMAP_FROM_PLAYER_POS_KEY, class_5198.field_24094, false);
    public static final class_4313<class_4310> DO_BETTERMAP_DYNAMIC_LOCATING = UnruledApi.registerBoolean(DO_BETTERMAP_DYNAMIC_LOCATING_KEY, class_5198.field_24094, true);
    public static final class_4313<class_4310> DO_BETTERMAPS_FEEDBACK = UnruledApi.registerBoolean(DO_BETTERMAPS_FEEDBACK_KEY, class_5198.field_24099, false);
    @SuppressWarnings("unused")
    public static final class_4313<class_4312> BETTERMAPS_MAX_TASKS = UnruledApi.intRuleBuilder(8)
            .setValidatorAdapter(new BoundedIntRuleValidatorAdapter(1, 64))
            .setChangeCallback((s, i) -> {
                mapTaskStepLock.lock();
                int j = i.method_20763();
                availablePermits.set(j);
                Semaphore sem = new Semaphore(i.method_20763());
                for (Map.Entry<String, LocateTask> e : locateMapTaskThreads.entrySet()) {
                    if (!e.getValue().isQueued() && availablePermits.get() > 0 && !sem.tryAcquire()) {
                        break;
                    }
                    availablePermits.decrementAndGet();
                }
                permits = i.method_20763();
                mapTaskMaxSemaphore = sem;
                mapTaskStepLock.unlock();
            })
            .register(BETTERMAPS_MAX_TASKS_KEY, class_5198.field_24100);
    public static final class_4313<class_4310> BETTERMAPS_QUEUE_TASKS = UnruledApi.registerBoolean(BETTERMAPS_QUEUE_TASKS_KEY, class_5198.field_24100, true);

    public static final String NBT_POS_DATA = "pos";
    public static final String NBT_EXPLORATION_DATA = "exploration";
    public static final String NBT_EXPLORATION_ICON = "decoration";
    public static final String NBT_EXPLORATION_DEST = "destination";
    public static final String NBT_EXPLORATION_DIM = "dimension";
    public static final String NBT_EXPLORATION_RADIUS = "searchRadius";
    public static final String NBT_EXPLORATION_SKIP = "skipExistingChunks";
    public static final String NBT_EXPLORATION_ZOOM = "zoom";
    public static final String NBT_MAP_LOCK = "_lock";

    public static final class_2960 NULL_ID = class_2960.method_60655(class_2960.field_33381, "_null");

    private static volatile boolean clientPaused = false;

    @Environment(EnvType.CLIENT)
    public static void setClientPaused(boolean b) {
        Bettermaps.clientPaused = b;
    }

    @Environment(EnvType.CLIENT)
    public static boolean isClientPaused() {
        return clientPaused;
    }

    public static class LocateTask extends Thread {
        private final class_3218 world;
        public final Runnable task;
        private final String id;
        private boolean queued = true;

        public LocateTask(class_3218 w, Runnable task, String id) {
            this.world = w;
            this.task = task;
            this.id = id;
        }

        @Override
        public void run() {
            mapTaskStepLock.lock();
            int available = availablePermits.get();
            mapTaskStepLock.unlock();
            if (world.method_64395().method_8355(BETTERMAPS_QUEUE_TASKS) && available == 0) {
                queue();
            }
            this.queued = false;
            this.task.run();
            mapTaskMaxSemaphore.release();
        }

        private void queue() {
            boolean b = true;
            while (b) {
                Bettermaps.mapTaskStepLock.lock();
                b = mapTaskMaxSemaphore.tryAcquire();
                Bettermaps.mapTaskStepLock.unlock();
                if (!b) {
                    try {
                        Thread.currentThread().wait(500);
                    } catch (InterruptedException e) {
                        // I honestly don't know why wouldn't it just wait
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        @Override
        public void interrupt() {
            mapTaskSafeLock.lock();
            locateMapTaskThreads.remove(id);
            mapTaskSafeLock.unlock();
            mapTaskMaxSemaphore.release();
            super.interrupt();
        }

        public String getTaskId() {
            return this.id;
        }

        public boolean isQueued() {
            return queued;
        }
    }

    public static boolean isLootEnabled(class_3218 w) {
        return isEnabled(w) && w.method_64395().method_8355(DO_BETTERMAPS_LOOT);
    }

    public static boolean isTradeEnabled(class_3218 w) {
        return isEnabled(w) && w.method_64395().method_8355(Bettermaps.DO_BETTERMAPS_TRADE);
    }

    public static boolean isEnabled(class_3218 w) {
        return w.method_64395().method_8355(DO_BETTERMAPS);
    }

    public static class_1799 createMap(class_243 origin, class_1937 sourceWorld, class_6862<class_3195> destination,
                                      class_2960 destWorld, class_6880<class_9428> decoration, byte zoom, int radius,
                                      boolean skipExistingChunks, @Nullable class_2561 displayName) {
        // pos logic
        class_2487 nbtPos = new class_2487();
        nbtPos.method_10582(Bettermaps.NBT_EXPLORATION_DIM, sourceWorld.method_27983().method_29177().toString());
        nbtPos.method_10549("x", origin.method_10216());
        nbtPos.method_10549("y", origin.method_10214());
        nbtPos.method_10549("z", origin.method_10215());

        // function args logic
        class_2487 explorationNbt = new class_2487();
        explorationNbt.method_10582(Bettermaps.NBT_EXPLORATION_DEST, destination.comp_327().toString());
        //noinspection OptionalGetWithoutIsPresent
        explorationNbt.method_10582(Bettermaps.NBT_EXPLORATION_ICON, decoration.method_40230().get().method_29177().toString());
        explorationNbt.method_10567(Bettermaps.NBT_EXPLORATION_ZOOM, zoom);
        explorationNbt.method_10569(Bettermaps.NBT_EXPLORATION_RADIUS, radius);
        explorationNbt.method_10556(Bettermaps.NBT_EXPLORATION_SKIP, skipExistingChunks);

        // function result logic
        class_1799 stack = new class_1799(class_1802.field_8895);
        class_2487 nbt = new class_2487();
        nbt.method_10566(Bettermaps.NBT_POS_DATA, nbtPos);
        nbt.method_10566(Bettermaps.NBT_EXPLORATION_DATA, explorationNbt);

        class_5250 lore = class_2561.method_43470("[")
                .method_10852(class_2561.method_48321(destWorld.method_42094(), destWorld.toString()))
                .method_10852(class_2561.method_43470("]")).method_27692(class_124.field_1063);
        if (displayName != null) {
            stack.method_57379(class_9334.field_49631, displayName);
        }

        storeMapData(nbt, stack, lore);
        stack.method_7939(1);
        return stack;
    }

    public static void storeMapData(class_2487 nbt, class_1799 stack, class_2561 lore) {
        class_9279 component = stack.method_57353().method_58695(field_49628, class_9279.field_49302);
        component = component.method_57451(c -> c.method_10566(MOD_ID, nbt));
        stack.method_57379(field_49628, component);
        if (lore != null) {
            class_9290 c = class_9290.field_49340.method_57499(lore);
            stack.method_57379(field_49632, c);
        }
    }

    public static void lockMap(class_1799 stack, String id) {
        class_9279 component = stack.method_57353().method_58695(field_49628, class_9279.field_49302);
        component.method_57451(c -> {
            if (!c.method_10545(MOD_ID)) return;
            class_2520 element = c.method_10580(MOD_ID);
            if (!(element instanceof class_2487 compound)) return;
            compound.method_10566(NBT_MAP_LOCK, class_2519.method_23256(id));
        });
    }
}
