package com.nerjal.bettermaps.mixins;

import com.nerjal.bettermaps.Bettermaps;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3853;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9306;
import net.minecraft.class_9428;

@Mixin(class_3853.class_1654.class)
public abstract class TradeOffersSellMapFactoryMixin {
    @Shadow @Final private class_6862<class_3195> structure;
    @Shadow @Final private class_6880<class_9428> decoration;
    @Shadow @Final private String nameKey;
    @Shadow @Final private int price;
    @Shadow @Final private int maxUses;
    @Shadow @Final private int experience;
    @Unique @SuppressWarnings("unused")
    private class_2960 explorationTargetWorld; // useless up to this day, will try to follow the vanilla behaviour and search in current dimension

    @Inject(method = "create", at = @At("HEAD"), cancellable = true)
    private void createInjector(class_1297 entity, class_5819 random, CallbackInfoReturnable<class_1914> cir) {
        if (!(entity.method_73183() instanceof class_3218 w)) return;
        if (!Bettermaps.isTradeEnabled(w)) {
            return;
        }
        class_2960 target = explorationTargetWorld == null ? w.method_27983().method_29177() : explorationTargetWorld;
        class_1799 stack = Bettermaps.createMap(entity.method_73189(), w, structure, target,
                decoration, (byte) 2, 100, true, class_2561.method_43471(nameKey));
        cir.setReturnValue(new class_1914(new class_9306(class_1802.field_8687, price), Optional.of(new class_9306(class_1802.field_8251, 1)), stack, maxUses, experience, 0.2F));
        cir.cancel();
    }
}
