package com.nerjal.bettermaps;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import org.jetbrains.annotations.NotNull;

import java.util.Comparator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2321;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

import static net.minecraft.class_2170.method_9247;

public final class BetterMapsCommand {
    private BetterMapsCommand(){}

    public static final SuggestionProvider<class_2168> TASKS = class_2321.method_10022(
            class_2960.method_60656("tasks"),
            (context, builder) -> class_2172.method_9265(Bettermaps.locateMapTaskThreads.keySet(), builder)
    );

    public static void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247("bettermaps")
                .requires(s -> s.method_9259(2))
                .then(
                        method_9247("list").executes(BetterMapsCommand::executeList)
                )
                .then(
                        method_9247("stop")
                                .then(class_2170.method_9244("id", StringArgumentType.string())
                                        .suggests(TASKS)
                                        .executes(BetterMapsCommand::stopTask)
                                )
                )
        );
    }

    @SuppressWarnings("SameReturnValue")
    private static int executeList(@NotNull CommandContext<class_2168> context) {
        Bettermaps.mapTaskStepLock.lock();
        if (Bettermaps.locateMapTaskThreads.isEmpty()) {
            context.getSource().method_45068(class_2561.method_43470("- 0 -"));
            return 0;
        }
        class_5250 t = class_2561.method_43473();
        List<class_5250> list = Bettermaps.locateMapTaskThreads.entrySet().stream()
                .sorted(Comparator.comparing(e -> (e.getValue().isQueued() ? 1 : 0) + e.getValue().getTaskId()))
                .map(e -> {
                    if (e.getValue().isQueued()) {
                        return class_2561.method_48321("bettermaps.command.queued", String.format("[Queued] %s", e.getKey())).method_27692(class_124.field_1065);
                    } else {
                        return class_2561.method_43470(e.getKey()).method_27692(class_124.field_1054);
                    }
                }).toList();
        Bettermaps.mapTaskStepLock.unlock();
        for (int i = 0; i < list.size(); i++) {
            t.method_10852(list.get(i));
            if (i+1 < list.size()) t.method_10852(class_2561.method_43470("\n"));
        }
        context.getSource().method_45068(t);
        return 0;
    }

    private static int stopTask(@NotNull CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, "id");
        if (Bettermaps.locateMapTaskThreads.containsKey(id)) {
            Bettermaps.LocateTask task = Bettermaps.locateMapTaskThreads.get(id);
            task.interrupt();
            context.getSource().method_9226(
                    () -> class_2561.method_43470(id).method_27692(class_124.field_1060),
                    false
            );
            return 0;
        }
        context.getSource().method_9213(class_2561.method_43470(id));
        return 1;
    }
}
