package com.nerjal.bettermaps.mixins;

import com.nerjal.bettermaps.Bettermaps;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_111;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1773;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.class_9428;

@Debug
@Mixin(class_1773.class)
public abstract class MapItemMixin {

    @Inject(method = "use", at = @At("HEAD"), cancellable = true)
    private void explorationMapUseInjector(
            @NotNull class_1937 w,
            class_1657 user,
            class_1268 hand,
            CallbackInfoReturnable<class_1269> cir
    ) {
        // basic checks
        if (w.method_8608()) return;
        class_3218 world = (class_3218) w;
        class_1799 stack = user.method_5998(hand);
        if (stack.method_7960()) return;
        class_9279 component = stack.method_58694(class_9334.field_49628);
        if (component == null) {
            return;
        }
        class_2487 srcNbt = component.method_57461();
        if (!srcNbt.method_10545(Bettermaps.MOD_ID)) return;
        class_2520 e = srcNbt.method_10580(Bettermaps.MOD_ID);
        if (!(e instanceof class_2487 nbt)) return;
        Optional<class_2487> opt1 = nbt.method_10562(Bettermaps.NBT_EXPLORATION_DATA);
        if (opt1.isEmpty()) return;

        if (nbt.method_10545(Bettermaps.NBT_MAP_LOCK)) {
            String s = nbt.method_68564(Bettermaps.NBT_MAP_LOCK, null);
            if (Bettermaps.locateMapTaskThreads.containsKey(s)) {
                user.method_7353(class_2561.method_43470("x").method_27695(class_124.field_1065, class_124.field_1067), true);
                cir.setReturnValue(class_1269.field_21466);
                cir.cancel();
                return;
            }
        }

        class_2487 explorationNbt = opt1.get();

        // locate
        int radius = explorationNbt.method_68083(Bettermaps.NBT_EXPLORATION_RADIUS, class_111.field_31852);
        boolean skip = explorationNbt.method_68566(Bettermaps.NBT_EXPLORATION_SKIP, class_111.field_31853);
        class_243 p = user.method_19538();
        class_2382 pos = new class_2382((int) p.field_1352, (int) p.field_1351, (int) p.field_1350);

        class_2960 destId = class_2960.method_12829(explorationNbt.method_68564(Bettermaps.NBT_EXPLORATION_DEST, null));
        class_6862<class_3195> destTag = class_6862.method_40092(class_7924.field_41246, destId);
        Optional<class_6885.class_6888<class_3195>> entryList = world.method_30349().method_30530(class_7924.field_41246).method_46733(destTag);
        Optional<class_6880.class_6883<class_3195>> entry = world.method_30349().method_30530(class_7924.field_41246).method_10223(destId);

        Optional<class_2487> opt2 = nbt.method_10562(Bettermaps.NBT_POS_DATA);
        if (opt2.isEmpty()) {
            return;
        }
        class_2487 posNbt = opt2.get();
        if (world.method_64395().method_8355(Bettermaps.DO_BETTERMAP_FROM_PLAYER_POS)) {
            pos = new class_2382(posNbt.method_68083("x", 0), posNbt.method_68083("y", 0), posNbt.method_68083("z", 0));
        }
        if (!world.method_27983().method_29177().toString().equals(posNbt.method_68564(Bettermaps.NBT_EXPLORATION_DIM, null))) {
            user.method_7353(class_2561.method_43470("x").method_27695(class_124.field_1061, class_124.field_1067), true);
            cir.setReturnValue(class_1269.field_21466);
            cir.cancel();
            return;
        }

        // locate task setup
        class_2382 fPos = pos;
        String id = String.format("%d-%s", Bettermaps.taskCounter.incrementAndGet(), user.method_5476().getString());
        class_6885<class_3195> entries = entryList.map(s -> (class_6885<class_3195>) s).or(() -> entry.map(class_6885::method_40246)).orElseThrow();
        boolean async = world.method_64395().method_8355(Bettermaps.DO_BETTERMAP_DYNAMIC_LOCATING);
        boolean feedback = world.method_64395().method_8355(Bettermaps.DO_BETTERMAPS_FEEDBACK);
        Runnable task = ()->locationTask(world, stack, nbt, explorationNbt, radius, skip, fPos, entries, user, id, async && feedback);
        if (! user.method_68878()) Bettermaps.lockMap(stack, id);

        // task run
        if (async) {
            Bettermaps.LocateTask locateTask = new Bettermaps.LocateTask(world, task, id);
            Bettermaps.locateMapTaskThreads.putIfAbsent(id, locateTask);
            if (feedback) {
                world.method_8503().method_3739().method_9226(() -> class_2561.method_48322(
                        "bettermaps.feedback.started",
                        String.format("User %s started location task with id %s", user.method_5476(), id),
                        user.method_5476(), id
                ), true);
            }
            locateTask.start();
            user.method_7353(class_2561.method_43470("\u2714").method_27695(class_124.field_1060, class_124.field_1067), true);
        } else {
            task.run();
        }

        cir.setReturnValue(class_1269.field_21466);
        cir.cancel();
    }

    @Unique
    private static void locationTask(
            @NotNull class_3218 world, @NotNull class_1799 stack, @NotNull class_2487 nbt,
            @NotNull class_2487 explorationNbt, int radius, boolean skip, @NotNull class_2382 pos,
            class_6885<class_3195> entries, @NotNull class_1657 user, String taskId, boolean feedback
    ) {
        //noinspection DataFlowIssue
        class_2338 blockPos = world.method_14178().method_12129().method_12103(world, entries, new class_2338(pos), radius, skip).getFirst();

        if (feedback) {
            world.method_8503().method_3739().method_9226(() -> class_2561.method_48322(
                    "bettermaps.feedback.end",
                    String.format("Locating task with ID %s started by player %s finished", taskId, user.method_5476()),
                    taskId, user.method_5476()
            ), true);
        }

        if (blockPos == null) {
            user.method_7353(class_2561.method_43470("x").method_27695(class_124.field_1058, class_124.field_1067), true);
            Bettermaps.locateMapTaskThreads.remove(taskId);
            return;
        }

        Bettermaps.mapTaskSafeLock.lock();
        // check user holds map
        if ((!user.method_5998(class_1268.field_5808).method_7960() && !user.method_5998(class_1268.field_5808).equals(stack))
                && !user.method_5998(class_1268.field_5810).method_7960() && !user.method_5998(class_1268.field_5810).equals(stack)) {
            Bettermaps.locateMapTaskThreads.remove(taskId);
            Bettermaps.mapTaskSafeLock.unlock();
            return;
        }

        // map data
        byte zoom = explorationNbt.method_68562(Bettermaps.NBT_EXPLORATION_ZOOM, class_111.field_31851);
        class_6880<class_9428> decoration = class_7923.field_50078.method_47983(
                class_7923.field_50078.method_63535(
                        class_2960.method_12829(explorationNbt.method_68564(Bettermaps.NBT_EXPLORATION_ICON, class_111.field_1034.method_55840()))
                )
        );

        // map creation
        class_1799 itemStack = class_1806.method_8005(world, blockPos.method_10263(), blockPos.method_10260(), zoom, true, true);
        class_1806.method_8002(world, itemStack);
        class_22.method_110(itemStack, blockPos, "+", decoration);
        nbt.method_10551(Bettermaps.NBT_POS_DATA);
        nbt.method_10551(Bettermaps.NBT_EXPLORATION_DATA);
        nbt.method_10551(Bettermaps.NBT_MAP_LOCK);
        Bettermaps.storeMapData(nbt, itemStack, null);

        //give to user
        //noinspection DataFlowIssue
        user.method_5682().execute(() -> {
            if (!user.method_31548().method_7394(itemStack.method_7972())) {
                user.method_7328(itemStack, false);
            }
            if (!user.method_68878()) {
                stack.method_7934(1);
            }
        });

        Bettermaps.locateMapTaskThreads.remove(taskId);
        Bettermaps.mapTaskSafeLock.unlock();
    }
}
