/*
 * Decompiled with CFR 0.152.
 */
package com.thijs226.grammarfix.compat;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ScreenCompat {
    private static final Logger LOGGER = LogManager.getLogger((String)"grammarfix/ScreenCompat");

    private ScreenCompat() {
    }

    public static void openChat(class_310 client, String initialMessage) {
        class_437 chatScreen = ScreenCompat.constructChatScreen(initialMessage);
        if (chatScreen != null) {
            client.method_1507(chatScreen);
        } else {
            LOGGER.warn("Unable to construct ChatScreen; leaving chat closed.");
        }
    }

    private static class_437 constructChatScreen(String initialMessage) {
        Constructor<?>[] constructors = class_408.class.getDeclaredConstructors();
        Arrays.sort(constructors, Comparator.comparingInt(Constructor::getParameterCount));
        for (Constructor<?> constructor : constructors) {
            constructor.setAccessible(true);
            Object[] arguments = ScreenCompat.buildArguments(constructor.getParameterTypes(), initialMessage);
            if (arguments == null) continue;
            try {
                Object instance = constructor.newInstance(arguments);
                if (!(instance instanceof class_437)) continue;
                class_437 screen = (class_437)instance;
                return screen;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOGGER.debug("ChatScreen constructor {} failed: {}", constructor, (Object)e.toString());
            }
        }
        return null;
    }

    private static Object[] buildArguments(Class<?>[] parameterTypes, String initialMessage) {
        Object[] arguments = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object value = ScreenCompat.resolveArgument(parameterTypes[i], initialMessage);
            if (value == Unresolved.INSTANCE) {
                return null;
            }
            arguments[i] = value;
        }
        return arguments;
    }

    private static Object resolveArgument(Class<?> type, String initialMessage) {
        ?[] constants;
        if (type == String.class) {
            return initialMessage;
        }
        if (class_2561.class.isAssignableFrom(type)) {
            return class_2561.method_43473();
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.FALSE;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return 0;
        }
        if (type == Long.TYPE || type == Long.class) {
            return 0L;
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE || type == Double.class) {
            return 0.0;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return (byte)0;
        }
        if (type == Short.TYPE || type == Short.class) {
            return (short)0;
        }
        if (type.isEnum() && (constants = type.getEnumConstants()) != null && constants.length > 0) {
            return constants[0];
        }
        if (type.isPrimitive()) {
            return Unresolved.INSTANCE;
        }
        return null;
    }

    private static enum Unresolved {
        INSTANCE;

    }
}

