/*
 * Decompiled with CFR 0.152.
 */
package com.thijs226.grammarfix.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static final String DEFAULT_BOT_SLUG = "Grammar-GPT-5";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "grammarfix.json");
    private static Config instance;
    @Deprecated
    public Boolean turboMode = null;
    public String apiKey = "";
    @Deprecated
    public String model = null;

    private Config() {
    }

    public static Config getInstance() {
        if (instance == null) {
            Config.load();
        }
        return instance;
    }

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                instance = (Config)GSON.fromJson((Reader)reader, Config.class);
            }
            catch (IOException e) {
                instance = new Config();
            }
        } else {
            instance = new Config();
            Config.save();
        }
        instance.ensureDefaults();
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)instance, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getBotSlug() {
        return DEFAULT_BOT_SLUG;
    }

    private void ensureDefaults() {
        if (instance != this) {
            return;
        }
        if (this.apiKey == null) {
            this.apiKey = "";
        }
        this.turboMode = null;
        this.model = null;
    }
}

