/*
 * Decompiled with CFR 0.152.
 */
package com.thijs226.grammarfix.config;

import java.lang.reflect.Method;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;

final class RenderCompat {
    private static final Method DRAW_TEXT_WITH_SHADOW_METHOD = RenderCompat.findDrawTextWithShadow();
    private static final Method DRAW_TEXT_METHOD = RenderCompat.findDrawText();

    private RenderCompat() {
    }

    private static Method findDrawTextWithShadow() {
        try {
            Method m = class_332.class.getMethod("drawText", class_327.class, class_2561.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            m.setAccessible(true);
            return m;
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    private static Method findDrawText() {
        try {
            Method m = class_332.class.getMethod("drawText", class_327.class, class_2561.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            m.setAccessible(true);
            return m;
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    static void drawText(class_332 context, class_327 renderer, class_2561 text, int x, int y, int color, boolean shadow) {
        if (RenderCompat.renderWithShadow(context, renderer, text, x, y, color, shadow)) {
            return;
        }
        if (shadow) {
            RenderCompat.renderWithoutShadow(context, renderer, text, x + 1, y, 0);
            RenderCompat.renderWithoutShadow(context, renderer, text, x, y + 1, 0);
        }
        RenderCompat.renderWithoutShadow(context, renderer, text, x, y, color);
    }

    private static boolean renderWithShadow(class_332 context, class_327 renderer, class_2561 text, int x, int y, int color, boolean shadow) {
        if (!shadow || DRAW_TEXT_WITH_SHADOW_METHOD == null) {
            return false;
        }
        try {
            DRAW_TEXT_WITH_SHADOW_METHOD.invoke((Object)context, renderer, text, x, y, color, Boolean.TRUE);
            return true;
        }
        catch (ReflectiveOperationException ignored) {
            return false;
        }
    }

    private static void renderWithoutShadow(class_332 context, class_327 renderer, class_2561 text, int x, int y, int color) {
        if (DRAW_TEXT_METHOD != null) {
            try {
                DRAW_TEXT_METHOD.invoke((Object)context, renderer, text, x, y, color);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
    }
}

