/*
 * Decompiled with CFR 0.152.
 */
package com.thijs226.grammarfix.network;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.thijs226.grammarfix.config.Config;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;

public class GrammarApi {
    private static final Gson GSON = new Gson();
    private static final HttpClient CLIENT = HttpClient.newHttpClient();
    private static final URI POE_ENDPOINT = URI.create("https://api.poe.com/v1/chat/completions");

    public static CompletableFuture<String> correctGrammar(String message) {
        String key;
        Config cfg = Config.getInstance();
        String string = key = cfg.apiKey == null ? "" : cfg.apiKey.trim();
        if (key == null || key.isBlank()) {
            return CompletableFuture.completedFuture(null);
        }
        JsonObject body = new JsonObject();
        body.addProperty("model", cfg.getBotSlug());
        JsonArray messages = new JsonArray();
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", message);
        messages.add((JsonElement)userMessage);
        body.add("messages", (JsonElement)messages);
        HttpRequest request = HttpRequest.newBuilder().uri(POE_ENDPOINT).header("Authorization", "Bearer " + key).header("Accept", "application/json").header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body.toString(), StandardCharsets.UTF_8)).build();
        return ((CompletableFuture)CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(resp -> {
            if (resp.statusCode() != 200) {
                return null;
            }
            JsonObject root = (JsonObject)GSON.fromJson((String)resp.body(), JsonObject.class);
            if (root == null) {
                return null;
            }
            JsonArray choices = root.getAsJsonArray("choices");
            if (choices == null || choices.isEmpty()) {
                return null;
            }
            JsonElement firstChoice = choices.get(0);
            if (!firstChoice.isJsonObject()) {
                return null;
            }
            JsonObject messageObject = firstChoice.getAsJsonObject().getAsJsonObject("message");
            if (messageObject == null || !messageObject.has("content")) {
                return null;
            }
            return GrammarApi.cleanResponse(messageObject.get("content").getAsString());
        })).exceptionally(e -> null);
    }

    private static String cleanResponse(String raw) {
        if (raw == null) {
            return null;
        }
        String trimmed = raw.trim();
        if (trimmed.startsWith("```")) {
            int firstLineBreak = trimmed.indexOf(10);
            if (firstLineBreak == -1) {
                return "";
            }
            if ((trimmed = trimmed.substring(firstLineBreak + 1).trim()).endsWith("```")) {
                trimmed = trimmed.substring(0, trimmed.length() - 3).trim();
            }
        }
        if (trimmed.endsWith("Copy code")) {
            trimmed = trimmed.substring(0, trimmed.length() - "Copy code".length()).trim();
        }
        return trimmed;
    }
}

