/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.quark_ponders.registry;

import com.leobeliik.quark_ponders.registry.ModuleRegistry;
import java.util.List;
import java.util.Map;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.api.registration.PonderSceneRegistrationHelper;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;

public class RegisterScenes
implements PonderPlugin,
ModuleRegistry {
    private static final Map<String, List<ModuleRegistry.ModuleSceneInfo>> MODULE_MAP = Map.of("automation", automationModules, "building", buildingModules, "tools", toolsModules, "tweaks", tweaksModules, "oddities", odditiesModules, "mobs", mobsModules);

    @NotNull
    public String getModId() {
        return "quark_ponders";
    }

    public void registerScenes(@NotNull PonderSceneRegistrationHelper<ResourceLocation> helper) {
        Quark.ZETA.modules.getCategories().stream().filter(category -> Quark.ZETA.configManager.isCategoryEnabled(category)).forEach(category -> RegisterScenes.loadScenes(helper, MODULE_MAP.get(category.name)));
    }

    private static void loadScenes(PonderSceneRegistrationHelper<ResourceLocation> helper, List<ModuleRegistry.ModuleSceneInfo> modules) {
        if (modules != null) {
            modules.stream().filter(info -> Quark.ZETA.modules.isEnabled(info.module())).forEach(info -> {
                if (info.rl() instanceof List) {
                    helper.forComponents((Iterable)((List)info.rl())).addStoryBoard(info.sbPath(), info.scene());
                } else {
                    helper.forComponents((Object[])new ResourceLocation[]{(ResourceLocation)info.rl()}).addStoryBoard(info.sbPath(), info.scene());
                }
            });
        }
    }
}

