/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.yardwatch;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import me.youhavetrouble.yardwatch.Protection;
import me.youhavetrouble.yardwatch.commands.YardWatchCommand;
import me.youhavetrouble.yardwatch.hooks.FactionsUUIDProtection;
import me.youhavetrouble.yardwatch.hooks.GriefPreventionProtection;
import me.youhavetrouble.yardwatch.hooks.LWCXProtection;
import me.youhavetrouble.yardwatch.hooks.PlotSquaredProtection;
import me.youhavetrouble.yardwatch.hooks.SuperiorSkyBlockProtection;
import me.youhavetrouble.yardwatch.hooks.TownyProtection;
import me.youhavetrouble.yardwatch.hooks.WorldGuardProtection;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public final class YardWatch
extends JavaPlugin {
    private static String yardWatchApiVersion = "Unknown";

    public void onEnable() {
        List registrations;
        try {
            URL url = this.getClassLoader().getResource("apiversion.txt");
            if (url != null) {
                yardWatchApiVersion = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
            }
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to read YardWatch API version.");
        }
        PluginCommand command = this.getCommand("yardwatch");
        if (command != null) {
            command.setExecutor((CommandExecutor)new YardWatchCommand(this));
        }
        if (this.shouldRegisterService("WorldGuard")) {
            this.getLogger().info("Registering WorldGuard service.");
            this.getServer().getServicesManager().register(Protection.class, (Object)new WorldGuardProtection(this), (Plugin)this, ServicePriority.Normal);
        }
        if (this.shouldRegisterService("GriefPrevention")) {
            this.getLogger().info("Registering GriefPrevention service.");
            this.getServer().getServicesManager().register(Protection.class, (Object)new GriefPreventionProtection(this), (Plugin)this, ServicePriority.Normal);
        }
        if (this.shouldRegisterService("LWC")) {
            this.getLogger().info("Registering LWC service.");
            this.getServer().getServicesManager().register(Protection.class, (Object)new LWCXProtection(this), (Plugin)this, ServicePriority.Normal);
        }
        if (this.shouldRegisterService("Factions")) {
            this.getLogger().info("Registering Factions service.");
            this.getServer().getServicesManager().register(Protection.class, (Object)new FactionsUUIDProtection(this), (Plugin)this, ServicePriority.Normal);
        }
        if (this.shouldRegisterService("SuperiorSkyblock2")) {
            this.getLogger().info("Registering SuperiorSkyblock2 service.");
            this.getServer().getServicesManager().register(Protection.class, (Object)new SuperiorSkyBlockProtection(this), (Plugin)this, ServicePriority.Normal);
        }
        if (this.shouldRegisterService("Towny")) {
            this.getLogger().info("Registering Towny service.");
            this.getServer().getServicesManager().register(Protection.class, (Object)new TownyProtection(this), (Plugin)this, ServicePriority.Normal);
        }
        if (this.shouldRegisterService("PlotSquared")) {
            this.getLogger().info("Registering PlotSquared service.");
            this.getServer().getServicesManager().register(Protection.class, (Object)new PlotSquaredProtection(this), (Plugin)this, ServicePriority.Normal);
        }
        if ((registrations = this.getServer().getServicesManager().getRegistrations((Plugin)this)).isEmpty()) {
            this.getLogger().info("Registered 0 services. This plugin can be safely removed.");
        } else {
            this.getLogger().info("Successfully registered " + registrations.size() + " services.");
        }
    }

    private boolean shouldRegisterService(String pluginName) {
        Plugin plugin = this.getServer().getPluginManager().getPlugin(pluginName);
        if (plugin == null || !plugin.isEnabled()) {
            return false;
        }
        List serviceProviders = this.getServer().getServicesManager().getRegistrations(plugin);
        for (RegisteredServiceProvider serviceProvider : serviceProviders) {
            if (serviceProvider.getService() != Protection.class) continue;
            return false;
        }
        return true;
    }

    public void onDisable() {
        this.getServer().getServicesManager().unregisterAll((Plugin)this);
    }

    public static String getYardWatchApiVersion() {
        return yardWatchApiVersion;
    }
}

