/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.yardwatch.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.youhavetrouble.yardwatch.Protection;
import me.youhavetrouble.yardwatch.YardWatch;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YardWatchCommand
implements TabExecutor {
    private final YardWatch plugin;
    private final String version;

    public YardWatchCommand(YardWatch plugin) {
        this.plugin = plugin;
        this.version = plugin.getDescription().getVersion();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            this.sendDefault(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("hooks")) {
            this.sendHooks(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("query")) {
            this.queryProtection(sender);
            return true;
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("hooks");
            completions.add("query");
            return (List)StringUtil.copyPartialMatches((String)args[0], completions, new ArrayList());
        }
        return completions;
    }

    private void sendDefault(CommandSender sender) {
        sender.sendMessage(String.format("YardWatch %s (Implementing YardWatch API %s)", this.version, YardWatch.getYardWatchApiVersion()));
    }

    private void sendHooks(CommandSender sender) {
        HashMap<String, Integer> hooks = new HashMap<String, Integer>();
        Collection protections = this.plugin.getServer().getServicesManager().getRegistrations(Protection.class);
        for (RegisteredServiceProvider registeredServiceProvider : protections) {
            hooks.merge(registeredServiceProvider.getPlugin().getName(), 1, Integer::sum);
        }
        if (hooks.isEmpty()) {
            sender.sendMessage("No hooks registered.");
            return;
        }
        sender.sendMessage("Hooks:");
        for (Map.Entry entry : hooks.entrySet()) {
            String hook = (Integer)entry.getValue() == 1 ? "hook" : "hooks";
            sender.sendMessage(String.format("%s -> %s %s registered", entry.getKey(), entry.getValue(), hook));
        }
    }

    private void queryProtection(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("You must be a player to use this command!");
            return;
        }
        Player player = (Player)sender;
        Location location = player.getLocation();
        sender.sendMessage("Protections at " + location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ());
        Collection protections = this.plugin.getServer().getServicesManager().getRegistrations(Protection.class);
        if (protections.isEmpty()) {
            sender.sendMessage("No protections registered at " + location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ());
            return;
        }
        for (RegisteredServiceProvider protection : protections) {
            Component component = ((TextComponent)Component.text((String)protection.getPlugin().getName()).append((Component)Component.text((String)(" isProtected " + ((Protection)protection.getProvider()).isProtected(location))))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)((TextComponent)Component.text((String)((Protection)protection.getProvider()).toString()).append((Component)Component.newline())).append(((TextComponent)((TextComponent)((TextComponent)Component.text((String)("canPlaceBlock " + ((Protection)protection.getProvider()).canPlaceBlock(player, location))).append((Component)Component.newline())).append((Component)Component.text((String)("canBreakBlock " + ((Protection)protection.getProvider()).canBreakBlock(player, location.getBlock().getState()))))).append((Component)Component.newline())).append((Component)Component.text((String)("canInteract " + ((Protection)protection.getProvider()).canInteract(player, location.getBlock().getState())))))));
            sender.sendMessage(component);
        }
    }
}

