/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.yardwatch.hooks;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.FactionsPlugin;
import com.massivecraft.factions.listeners.FactionsBlockListener;
import com.massivecraft.factions.listeners.FactionsEntityListener;
import com.massivecraft.factions.listeners.FactionsPlayerListener;
import com.massivecraft.factions.perms.PermissibleAction;
import com.massivecraft.factions.perms.PermissibleActions;
import me.youhavetrouble.yardwatch.Protection;
import me.youhavetrouble.yardwatch.YardWatch;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class FactionsUUIDProtection
implements Protection {
    private final YardWatch plugin;

    public FactionsUUIDProtection(YardWatch plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.getServer().getPluginManager().isPluginEnabled("Factions");
    }

    @Override
    public boolean isProtected(Location location) {
        if (!this.isEnabled()) {
            return false;
        }
        if (!FactionsPlugin.getInstance().worldUtil().isEnabled(location.getWorld())) {
            return false;
        }
        FLocation fLocation = new FLocation(location);
        Faction faction = Board.getInstance().getFactionAt(fLocation);
        return !faction.isWilderness();
    }

    @Override
    public boolean canBreakBlock(Player player, BlockState blockState) {
        if (!this.isEnabled()) {
            return true;
        }
        if (!FactionsPlugin.getInstance().worldUtil().isEnabled(blockState.getWorld())) {
            return true;
        }
        return FactionsBlockListener.playerCanBuildDestroyBlock((Player)player, (Location)blockState.getLocation(), (PermissibleAction)PermissibleActions.DESTROY, (boolean)true);
    }

    @Override
    public boolean canPlaceBlock(Player player, Location location) {
        if (!this.isEnabled()) {
            return true;
        }
        if (!FactionsPlugin.getInstance().worldUtil().isEnabled(location.getWorld())) {
            return true;
        }
        return FactionsBlockListener.playerCanBuildDestroyBlock((Player)player, (Location)location, (PermissibleAction)PermissibleActions.BUILD, (boolean)true);
    }

    @Override
    public boolean canInteract(Player player, BlockState blockState) {
        if (!this.isEnabled()) {
            return true;
        }
        if (!FactionsPlugin.getInstance().worldUtil().isEnabled(blockState.getWorld())) {
            return true;
        }
        return FactionsPlayerListener.canUseBlock((Player)player, (Material)blockState.getType(), (Location)blockState.getLocation(), (boolean)true);
    }

    @Override
    public boolean canInteract(Player player, Entity target) {
        if (!this.isEnabled()) {
            return true;
        }
        if (!FactionsPlugin.getInstance().worldUtil().isEnabled((CommandSender)target)) {
            return true;
        }
        return FactionsEntityListener.canInteractHere((Player)player, (Location)target.getLocation());
    }

    @Override
    public boolean canDamage(Entity damager, Entity target) {
        if (!this.isEnabled()) {
            return true;
        }
        if (!FactionsPlugin.getInstance().worldUtil().isEnabled((CommandSender)target)) {
            return true;
        }
        return FactionsEntityListener.canDamage((Entity)damager, (Entity)target, (boolean)false);
    }
}

