/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.yardwatch.hooks;

import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.implementations.PvpFlag;
import me.youhavetrouble.yardwatch.Protection;
import me.youhavetrouble.yardwatch.YardWatch;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PlotSquaredProtection
implements Protection {
    private final YardWatch plugin;

    public PlotSquaredProtection(YardWatch plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.getServer().getPluginManager().isPluginEnabled("PlotSquared");
    }

    @Override
    public boolean isProtected(org.bukkit.Location location) {
        if (!this.isEnabled()) {
            return false;
        }
        Location arg1 = this.getLocation(location);
        return arg1.isPlotArea() || arg1.isPlotRoad() || arg1.isUnownedPlotArea() || arg1.getOwnedPlot() != null;
    }

    @Override
    public boolean canBreakBlock(Player player, BlockState blockState) {
        if (!this.isEnabled()) {
            return true;
        }
        org.bukkit.Location blockLocation = blockState.getLocation();
        @NonNull Location location = this.getLocation(blockLocation);
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            return this.isProtected(blockLocation);
        }
        return plot.isAdded(player.getUniqueId());
    }

    @Override
    public boolean canPlaceBlock(Player player, org.bukkit.Location location) {
        return this.canBreakBlock(player, location.getBlock().getState());
    }

    @Override
    public boolean canInteract(Player player, BlockState blockState) {
        if (!this.isEnabled()) {
            return true;
        }
        org.bukkit.Location location = blockState.getLocation();
        @NonNull Location plotLocation = this.getLocation(location);
        Plot plot = plotLocation.getOwnedPlot();
        if (plot == null) {
            return this.isProtected(location);
        }
        return plot.isAdded(player.getUniqueId());
    }

    @Override
    public boolean canInteract(Player player, Entity target) {
        return this.canInteract(player, target.getLocation().getBlock().getState());
    }

    @Override
    public boolean canDamage(Entity damager, Entity target) {
        if (!this.isEnabled() || !(damager instanceof Player)) {
            return true;
        }
        org.bukkit.Location location = target.getLocation();
        @NonNull Location plotLocation = this.getLocation(location);
        Plot plot = plotLocation.getOwnedPlot();
        if (plot == null) {
            return this.isProtected(location);
        }
        return (Boolean)plot.getFlag(PvpFlag.class);
    }

    private @NonNull Location getLocation(org.bukkit.Location location) {
        String world = location.getWorld().getName();
        int x = (int)location.getX();
        int y = (int)location.getY();
        int z = (int)location.getZ();
        return Location.at((String)world, (int)x, (int)y, (int)z);
    }
}

