/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.yardwatch.hooks;

import com.bgsoftware.superiorskyblock.api.SuperiorSkyblockAPI;
import com.bgsoftware.superiorskyblock.api.island.Island;
import com.bgsoftware.superiorskyblock.api.island.IslandPrivilege;
import me.youhavetrouble.yardwatch.Protection;
import me.youhavetrouble.yardwatch.YardWatch;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SuperiorSkyBlockProtection
implements Protection {
    private final YardWatch plugin;

    public SuperiorSkyBlockProtection(YardWatch plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.getServer().getPluginManager().isPluginEnabled("SuperiorSkyblock2");
    }

    @Override
    public boolean isProtected(Location location) {
        if (!this.isEnabled()) {
            return false;
        }
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)location);
        return island != null;
    }

    @Override
    public boolean canBreakBlock(Player player, BlockState blockState) {
        if (!this.isEnabled()) {
            return true;
        }
        Location location = blockState.getLocation();
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)location);
        return island == null || island.hasPermission((CommandSender)player, IslandPrivilege.getByName((String)"BREAK"));
    }

    @Override
    public boolean canPlaceBlock(Player player, Location location) {
        if (!this.isEnabled()) {
            return true;
        }
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)location);
        return island == null || island.hasPermission((CommandSender)player, IslandPrivilege.getByName((String)"INTERACT"));
    }

    @Override
    public boolean canInteract(Player player, BlockState blockState) {
        if (!this.isEnabled()) {
            return true;
        }
        Location location = blockState.getLocation();
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)location);
        return island == null || island.hasPermission((CommandSender)player, IslandPrivilege.getByName((String)"INTERACT"));
    }

    @Override
    public boolean canInteract(Player player, Entity target) {
        if (!this.isEnabled()) {
            return true;
        }
        Location location = target.getLocation();
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)location);
        return island == null || island.hasPermission((CommandSender)player, IslandPrivilege.getByName((String)"INTERACT")) || island.hasPermission((CommandSender)player, IslandPrivilege.getByName((String)"USE"));
    }

    @Override
    public boolean canDamage(Entity damager, Entity target) {
        if (!this.isEnabled()) {
            return true;
        }
        if (!(damager instanceof Player)) {
            return true;
        }
        Player attacker = (Player)damager;
        Location location = target.getLocation();
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)location);
        return island == null || island.hasPermission((CommandSender)attacker, IslandPrivilege.getByName((String)"INTERACT"));
    }
}

