/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.yardwatch.hooks;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import me.youhavetrouble.yardwatch.Protection;
import me.youhavetrouble.yardwatch.YardWatch;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TownyProtection
implements Protection {
    private final YardWatch plugin;
    private final TownyAPI api;

    public TownyProtection(YardWatch plugin) {
        this.plugin = plugin;
        this.api = TownyAPI.getInstance();
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.getServer().getPluginManager().isPluginEnabled("Towny");
    }

    @Override
    public boolean isProtected(Location location) {
        if (!this.isEnabled()) {
            return false;
        }
        TownBlock town = this.api.getTownBlock(location);
        return town != null;
    }

    @Override
    public boolean canBreakBlock(Player player, BlockState blockState) {
        return this.canInteract(player, blockState);
    }

    @Override
    public boolean canPlaceBlock(Player player, Location location) {
        return this.canInteract(player, location.getBlock().getState());
    }

    @Override
    public boolean canInteract(Player player, BlockState blockState) {
        if (!this.isEnabled()) {
            return true;
        }
        Location location = blockState.getLocation();
        TownBlock town = this.api.getTownBlock(location);
        Resident resident = this.api.getResident(player.getUniqueId());
        return town == null || town.hasResident(resident) || town.hasTrustedResident(resident);
    }

    @Override
    public boolean canInteract(Player player, Entity target) {
        return this.canInteract(player, target.getLocation().getBlock().getState());
    }

    @Override
    public boolean canDamage(Entity damager, Entity target) {
        if (!this.isEnabled()) {
            return true;
        }
        if (!(damager instanceof Player)) {
            return true;
        }
        Location location = target.getLocation();
        TownBlock town = this.api.getTownBlock(location);
        return town == null || CombatUtil.preventPvP((TownyWorld)town.getWorld(), (TownBlock)town);
    }
}

