/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.yardwatch.hooks;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.domains.Association;
import com.sk89q.worldguard.protection.association.Associables;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import me.youhavetrouble.yardwatch.Protection;
import me.youhavetrouble.yardwatch.YardWatch;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class WorldGuardProtection
implements Protection {
    private final YardWatch plugin;

    public WorldGuardProtection(YardWatch plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.getServer().getPluginManager().isPluginEnabled("WorldGuard");
    }

    @Override
    public boolean isProtected(Location location) {
        if (!this.isEnabled()) {
            return false;
        }
        if (location.getWorld() == null) {
            return false;
        }
        com.sk89q.worldedit.util.Location wgLocation = BukkitAdapter.adapt((Location)location);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        return query.testBuild(wgLocation, Associables.constant((Association)Association.NON_MEMBER), new StateFlag[0]);
    }

    @Override
    public boolean canBreakBlock(Player player, BlockState blockState) {
        if (!this.isEnabled()) {
            return true;
        }
        Location location = blockState.getLocation();
        com.sk89q.worldedit.util.Location wgLocation = BukkitAdapter.adapt((Location)location);
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player, true);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        return query.testState(wgLocation, localPlayer, new StateFlag[]{Flags.BUILD});
    }

    @Override
    public boolean canPlaceBlock(Player player, Location location) {
        if (!this.isEnabled()) {
            return true;
        }
        com.sk89q.worldedit.util.Location wgLocation = BukkitAdapter.adapt((Location)location);
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player, true);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        return query.testState(wgLocation, localPlayer, new StateFlag[]{Flags.BUILD});
    }

    @Override
    public boolean canInteract(Player player, BlockState blockState) {
        if (!this.isEnabled()) {
            return true;
        }
        com.sk89q.worldedit.util.Location wgLocation = BukkitAdapter.adapt((Location)blockState.getLocation());
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player, true);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        return query.testState(wgLocation, localPlayer, new StateFlag[]{Flags.INTERACT});
    }

    @Override
    public boolean canInteract(Player player, Entity entity) {
        if (!this.isEnabled()) {
            return true;
        }
        com.sk89q.worldedit.util.Location wgLocation = BukkitAdapter.adapt((Location)entity.getLocation());
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player, true);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        return query.testState(wgLocation, localPlayer, new StateFlag[]{Flags.INTERACT});
    }

    @Override
    public boolean canDamage(Entity attacker, Entity target) {
        if (!this.isEnabled()) {
            return true;
        }
        if (!(attacker instanceof Player)) {
            return true;
        }
        Player player = (Player)attacker;
        com.sk89q.worldedit.util.Location wgLocation = BukkitAdapter.adapt((Location)target.getLocation());
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player, true);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        return query.testState(wgLocation, localPlayer, new StateFlag[]{Flags.INTERACT});
    }
}

