package net.vulkanmod.config.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import org.joml.Matrix4f;

import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_9801;

public abstract class GuiRenderer {

    public static class_310 minecraft;
    public static class_327 font;
    public static class_332 guiGraphics;
    public static class_4587 pose;
    public static class_287 bufferBuilder;

    private static boolean batching = false;
    private static boolean drawing = false;

    public static void setPoseStack(class_4587 poseStack) {
        pose = poseStack;
    }

    public static void disableScissor() {
        RenderSystem.disableScissor();
    }

    public static void enableScissor(int x, int y, int width, int height) {
        class_1041 window = class_310.method_1551().method_22683();
        int wHeight = window.method_4506();
        double scale = window.method_4495();
        int xScaled = (int) (x * scale);
        int yScaled = (int) (wHeight - (y + height) * scale);
        int widthScaled = (int) (width * scale);
        int heightScaled = (int) (height * scale);
        RenderSystem.enableScissor(xScaled, yScaled, Math.max(0, widthScaled), Math.max(0, heightScaled));
    }

    public static void fillBox(float x0, float y0, float width, float height, int color) {
        fill(x0, y0, x0 + width, y0 + height, 0, color);
    }

    public static void fill(float x0, float y0, float x1, float y1, int color) {
        fill(x0, y0, x1, y1, 0, color);
    }

    public static void fill(float x0, float y0, float x1, float y1, float z, int color) {
        Matrix4f matrix4f = pose.method_23760().method_23761();

        setupBufferBuilder();

        bufferBuilder.method_22918(matrix4f, x0, y0, z).method_39415(color);
        bufferBuilder.method_22918(matrix4f, x0, y1, z).method_39415(color);
        bufferBuilder.method_22918(matrix4f, x1, y1, z).method_39415(color);
        bufferBuilder.method_22918(matrix4f, x1, y0, z).method_39415(color);

        submitIfNeeded();
    }

    public static void fillGradient(float x0, float y0, float x1, float y1, int color1, int color2) {
        fillGradient(x0, y0, x1, y1, 0, color1, color2);
    }

    public static void fillGradient(float x0, float y0, float x1, float y1, float z, int color1, int color2) {
        Matrix4f matrix4f = pose.method_23760().method_23761();

        setupBufferBuilder();

        bufferBuilder.method_22918(matrix4f, x0, y0, z).method_39415(color1);
        bufferBuilder.method_22918(matrix4f, x0, y1, z).method_39415(color2);
        bufferBuilder.method_22918(matrix4f, x1, y1, z).method_39415(color2);
        bufferBuilder.method_22918(matrix4f, x1, y0, z).method_39415(color1);

        submitIfNeeded();
    }

    public static void renderBoxBorder(float x0, float y0, float width, float height, float borderWidth, int color) {
        renderBorder(x0, y0, x0 + width, y0 + height, borderWidth, color);
    }

    public static void renderBorder(float x0, float y0, float x1, float y1, float width, int color) {
        GuiRenderer.fill(x0, y0, x1, y0 + width, color);
        GuiRenderer.fill(x0, y1 - width, x1, y1, color);

        GuiRenderer.fill(x0, y0 + width, x0 + width, y1 - width, color);
        GuiRenderer.fill(x1 - width, y0 + width, x1, y1 - width, color);
    }

    public static void drawString(class_327 font, class_2561 component, int x, int y, int color) {
        drawString(font, component.method_30937(), x, y, color);
    }

    public static void drawString(class_327 font, class_5481 formattedCharSequence, int x, int y, int color) {
        guiGraphics.method_35720(font, formattedCharSequence, x, y, color);
    }

    public static void drawString(class_327 font, class_2561 component, int x, int y, int color, boolean shadow) {
        drawString(font, component.method_30937(), x, y, color, shadow);
    }

    public static void drawString(class_327 font, class_5481 formattedCharSequence, int x, int y, int color, boolean shadow) {
        guiGraphics.method_51430(font, formattedCharSequence, x, y, color, shadow);
    }

    public static void drawCenteredString(class_327 font, class_2561 component, int x, int y, int color) {
        class_5481 formattedCharSequence = component.method_30937();
        guiGraphics.method_35720(font, formattedCharSequence, x - font.method_30880(formattedCharSequence) / 2, y, color);
    }

    public static int getMaxTextWidth(class_327 font, List<class_5481> list) {
        int maxWidth = 0;
        for (var text : list) {
            int width = font.method_30880(text);
            if (width > maxWidth) {
                maxWidth = width;
            }
        }
        return maxWidth;
    }

    public static void beginBatch() {
        batching = true;
    }

    public static void endBatch() {
        class_1921 renderType = class_1921.method_51784();
        class_9801 meshData = bufferBuilder.method_60794();

        if (meshData != null) {
            renderType.method_60895(meshData);
        }

        batching = false;
        drawing = false;
    }

    public static void flush() {
        guiGraphics.method_51452();

        if (batching) {
            endBatch();
        }
    }

    private static void setupBufferBuilder() {
        if (!batching || !drawing) {
            bufferBuilder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
            drawing = true;
        }
    }

    private static void submitIfNeeded() {
        if (!batching) {
            class_1921 renderType = class_1921.method_51784();
            renderType.method_60895(bufferBuilder.method_60800());
            drawing = false;
        }
    }
}
