package net.vulkanmod.mixin.compatibility;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import net.minecraft.class_10366;
import net.minecraft.class_276;
import net.minecraft.class_283;
import net.minecraft.class_2960;
import net.minecraft.class_6364;
import net.minecraft.class_9909;
import net.minecraft.class_9916;
import net.minecraft.class_9925;
import net.minecraft.class_9962;
import net.vulkanmod.render.engine.*;
import net.vulkanmod.vulkan.Renderer;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.vulkan.VK10;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Consumer;

@Mixin(class_283.class)
public abstract class PostPassM {
    @Shadow @Final private String name;

    @Shadow @Final private List<class_283.class_9971> inputs;
    @Shadow @Final private class_2960 outputTargetId;
    @Shadow @Final private List<class_9962.class_9970> uniforms;

//    @Shadow protected abstract void restoreDefaultUniforms();

    @Shadow @Final private RenderPipeline pipeline;

    /**
     * @author
     * @reason
     */
    @Overwrite
    public void addToFrame(
            class_9909 frameGraphBuilder, Map<class_2960, class_9925<class_276>> map, Matrix4f matrix4f, @Nullable Consumer<RenderPass> consumer
    ) {
        class_9916 framePass = frameGraphBuilder.method_61911(this.name);

        for (class_283.class_9971 input : this.inputs) {
            input.method_62259(framePass, map);
        }

        class_9925<class_276> resourceHandle = (class_9925<class_276>)map.computeIfPresent(
                this.outputTargetId, (resourceLocation, resourceHandlex) -> framePass.method_61933(resourceHandlex)
        );
        if (resourceHandle == null) {
            throw new IllegalStateException("Missing handle for target " + this.outputTargetId);
        } else {
            framePass.method_61929(
                    () -> {
                        class_276 renderTarget = resourceHandle.get();
                        RenderSystem.backupProjectionMatrix();
                        RenderSystem.setProjectionMatrix(matrix4f, class_10366.field_54954);
                        VkGpuBuffer quadVertexBuffer = (VkGpuBuffer) RenderSystem.getQuadVertexBuffer();
                        RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer(VertexFormat.class_5596.field_27382);
                        VkGpuBuffer indexBuffer = (VkGpuBuffer) autoStorageIndexBuffer.method_68274(6);

                        Renderer.getInstance().endRenderPass();

                        for (class_283.class_9971 inputx : this.inputs) {
                            if (inputx instanceof class_283.class_9972) {
                                var targetId = ((class_283.class_9972) inputx).comp_3035();
                                var inTarget = map.get(targetId).get();

                                if (inTarget instanceof class_6364) {
                                    VkGpuTexture colorTexture = (VkGpuTexture) inTarget.method_30277();
                                    colorTexture.getVulkanImage().readOnlyLayout();

                                    VkGpuTexture depthTexture = (VkGpuTexture) inTarget.method_30278();
                                    if (depthTexture != null) {
                                        depthTexture.getVulkanImage().readOnlyLayout();
                                    }
                                }
                            }

//                            inputx.bindTo(this.shader, map);
                        }

                        try (RenderPass renderPass = RenderSystem.getDevice()
                                                                 .createCommandEncoder()
                                                                 .createRenderPass(
                                                                         renderTarget.method_30277(), OptionalInt.empty(), renderTarget.field_1478 ? renderTarget.method_30278() : null, OptionalDouble.empty()
                                                                 )) {
                            renderPass.setPipeline(this.pipeline);
                            renderPass.setUniform("OutSize", (float)renderTarget.field_1482, (float)renderTarget.field_1481);
                            renderPass.setVertexBuffer(0, quadVertexBuffer);
                            renderPass.setIndexBuffer(indexBuffer, autoStorageIndexBuffer.method_31924());

                            for (class_283.class_9971 inputx : this.inputs) {
                                inputx.method_62260(renderPass, map);
                            }

                            if (consumer != null) {
                                consumer.accept(renderPass);
                            }

                            for (class_9962.class_9970 uniform : this.uniforms) {
                                uniform.method_68482(renderPass);
                            }

//                            Renderer.setInvertedViewport(0, 0, renderTarget.width, renderTarget.height);
//                            Renderer.resetScissor();
//                            VRenderSystem.disableCull();
//
                            VkGpuDevice gpuDevice = (VkGpuDevice) RenderSystem.getDevice();
                            VkCommandEncoder commandEncoder = (VkCommandEncoder) gpuDevice.createCommandEncoder();
//                            commandEncoder.trySetup((VkRenderPass) renderPass);
//
//                            {
//                                ExtendedRenderPipeline extRenderPipeline = ExtendedRenderPipeline.of(this.pipeline);
//                                Pipeline pipeline = extRenderPipeline.getPipeline();
//
//                                Renderer renderer = Renderer.getInstance();
//                                renderer.bindGraphicsPipeline((GraphicsPipeline) pipeline);
//                                VTextureSelector.bindShaderTextures(pipeline);
//                                renderer.uploadAndBindUBOs(pipeline);
//                            }

//                            renderPass.drawIndexed(0, 6);

                            commandEncoder.setupUniforms((VkRenderPass) renderPass);
                            commandEncoder.bindPipeline(((VkRenderPass) renderPass).getPipeline());

                            int indexType = switch (autoStorageIndexBuffer.method_31924()) {
                                case field_27372 -> VK10.VK_INDEX_TYPE_UINT16;
                                case field_27373 -> VK10.VK_INDEX_TYPE_UINT32;
                            };

                            Renderer.getDrawer().drawIndexed(quadVertexBuffer.getBuffer(), indexBuffer.getBuffer(), 6, indexType);
                        }

                        RenderSystem.restoreProjectionMatrix();

//                        Renderer.resetViewport();
//                        VRenderSystem.enableCull();

                        for (class_283.class_9971 input2 : this.inputs) {
                            input2.method_62261(map);
                        }
                    }
            );
        }
    }

}
