package net.vulkanmod.mixin.profiling;

import net.minecraft.class_243;
import net.minecraft.class_3695;
import net.minecraft.class_4063;
import net.minecraft.class_4184;
import net.minecraft.class_4604;
import net.minecraft.class_761;
import net.minecraft.class_9779;
import net.minecraft.class_9925;
import net.minecraft.class_9958;
import net.vulkanmod.render.profiling.Profiler;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_761.class)
public class LevelRendererMixin {

    @Inject(method = "method_62205", at = @At("HEAD"))
    private void pushProfiler(int i, class_4063 cloudStatus, float f, class_243 vec3, float g, CallbackInfo ci) {
        Profiler profiler = Profiler.getMainProfiler();
        profiler.push("Clouds");
    }

    @Inject(method = "method_62205", at = @At("RETURN"))
    private void popProfiler(int i, class_4063 cloudStatus, float f, class_243 vec3, float g, CallbackInfo ci) {
        Profiler profiler = Profiler.getMainProfiler();
        profiler.pop();
    }

    // TODO: fix
    @Inject(method = "method_62213", at = @At(value = "HEAD"))
    private void pushProfiler3(class_9958 fogParameters, class_9925 resourceHandle,
                               class_9925 resourceHandle2, class_4184 camera, float f, CallbackInfo ci) {
        Profiler profiler = Profiler.getMainProfiler();
        profiler.push("Particles");
    }

    @Inject(method = "method_62213", at = @At(value = "RETURN"))
    private void popProfiler3(class_9958 fogParameters, class_9925 resourceHandle,
                              class_9925 resourceHandle2, class_4184 camera, float f, CallbackInfo ci) {
        Profiler profiler = Profiler.getMainProfiler();
        profiler.pop();
    }

    @Inject(method = "method_62214",
            at = @At(value = "INVOKE",
                     target = "Lnet/minecraft/client/renderer/LevelRenderer;renderSectionLayer(Lnet/minecraft/client/renderer/RenderType;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V",
                     ordinal = 0,
                     shift = At.Shift.BEFORE))
    private void profilerTerrain1(class_9958 fogParameters, class_9779 deltaTracker, class_4184 camera,
                                  class_3695 profilerFiller, Matrix4f matrix4f, Matrix4f matrix4f2,
                                  class_9925 resourceHandle, class_9925 resourceHandle2, boolean bl,
                                  class_4604 frustum, class_9925 resourceHandle3, class_9925 resourceHandle4,
                                  CallbackInfo ci) {
        Profiler profiler = Profiler.getMainProfiler();
        profiler.push("Opaque_terrain");
    }

    @Inject(method = "method_62214",
            at = @At(value = "INVOKE",
                     target = "Lnet/minecraft/client/renderer/LevelRenderer;renderEntities(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/Camera;Lnet/minecraft/client/DeltaTracker;Ljava/util/List;)V"))
    private void profilerTerrain2(class_9958 fogParameters, class_9779 deltaTracker, class_4184 camera,
                                  class_3695 profilerFiller, Matrix4f matrix4f, Matrix4f matrix4f2,
                                  class_9925 resourceHandle, class_9925 resourceHandle2, boolean bl,
                                  class_4604 frustum, class_9925 resourceHandle3, class_9925 resourceHandle4,
                                  CallbackInfo ci) {
        Profiler profiler = Profiler.getMainProfiler();
        profiler.pop();
        profiler.push("entities");
    }

    @Inject(method = "method_62214",
            at = @At(value = "INVOKE",
                     target = "Lnet/minecraft/client/renderer/LevelRenderer;renderSectionLayer(Lnet/minecraft/client/renderer/RenderType;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V",
                     ordinal = 3,
                     shift = At.Shift.BEFORE))
    private void profilerTerrain3(class_9958 fogParameters, class_9779 deltaTracker, class_4184 camera,
                                  class_3695 profilerFiller, Matrix4f matrix4f, Matrix4f matrix4f2,
                                  class_9925 resourceHandle, class_9925 resourceHandle2, boolean bl,
                                  class_4604 frustum, class_9925 resourceHandle3, class_9925 resourceHandle4,
                                  CallbackInfo ci) {
        Profiler profiler = Profiler.getMainProfiler();
        profiler.pop();
        profiler.push("Translucent_terrain");
    }

    @Inject(method = "method_62214",
            at = @At(value = "INVOKE",
                     target = "Lnet/minecraft/client/renderer/LevelRenderer;renderSectionLayer(Lnet/minecraft/client/renderer/RenderType;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V",
                     ordinal = 4,
                     shift = At.Shift.AFTER))
    private void profilerTerrain4(class_9958 fogParameters, class_9779 deltaTracker, class_4184 camera,
                                  class_3695 profilerFiller, Matrix4f matrix4f, Matrix4f matrix4f2,
                                  class_9925 resourceHandle, class_9925 resourceHandle2, boolean bl,
                                  class_4604 frustum, class_9925 resourceHandle3, class_9925 resourceHandle4,
                                  CallbackInfo ci) {
        Profiler profiler = Profiler.getMainProfiler();
        profiler.pop();
    }


}
