package net.vulkanmod.mixin.render;

import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import net.minecraft.class_1041;
import net.minecraft.class_1921;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_9801;
import net.vulkanmod.interfaces.shader.ExtendedRenderPipeline;
import net.vulkanmod.render.engine.EGlProgram;
import net.vulkanmod.render.engine.VkCommandEncoder;
import net.vulkanmod.render.engine.VkGpuTexture;
import net.vulkanmod.vulkan.Renderer;
import net.vulkanmod.vulkan.VRenderSystem;
import net.vulkanmod.vulkan.shader.GraphicsPipeline;
import net.vulkanmod.vulkan.shader.Pipeline;
import net.vulkanmod.vulkan.texture.VTextureSelector;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

import java.util.OptionalDouble;
import java.util.OptionalInt;

@Mixin(class_1921.class_4687.class)
public abstract class CompositeRenderTypeM {

    @Shadow public abstract RenderPipeline getRenderPipeline();

    @Shadow @Final private class_1921.class_4688 state;

//    @Inject(method = "draw", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderPass;setPipeline(Lcom/mojang/blaze3d/pipeline/RenderPipeline;)V", shift = At.Shift.AFTER))
//    private void bindPipeline(MeshData par1, CallbackInfo ci, @Local RenderPipeline renderPipeline) {
//        try {
//            Pipeline pipeline = ExtendedRenderPipeline.of(renderPipeline).getPipeline();
//
//            Renderer renderer = Renderer.getInstance();
//            renderer.bindGraphicsPipeline((GraphicsPipeline) pipeline);
//            VTextureSelector.bindShaderTextures(pipeline);
//            renderer.uploadAndBindUBOs(pipeline);
//        } catch (Exception e) {
//            throw new RuntimeException(e);
//        }
//
//    }

    @Shadow @Final private RenderPipeline renderPipeline;

    /**
     * @author
     * @reason
     */
    @Overwrite
    public void draw(class_9801 meshData) {
        RenderPipeline renderPipeline = this.getRenderPipeline();
        ((class_1921.class_4687)(Object)(this)).method_23516();

        try {
            class_276 renderTarget = ((CompositeStateAccessor)(Object)this.state).getOutputState().method_68491();
            VkCommandEncoder commandEncoder = (VkCommandEncoder) RenderSystem.getDevice().createCommandEncoder();

            try (RenderPass renderPass = commandEncoder.createRenderPass(
                    renderTarget.method_30277(), OptionalInt.empty(), renderTarget.field_1478 ? renderTarget.method_30278() : null, OptionalDouble.empty()
                )) {
                renderPass.setPipeline(renderPipeline);
                if (RenderSystem.SCISSOR_STATE.isEnabled()) {
                    renderPass.enableScissor(RenderSystem.SCISSOR_STATE);
                }

                for (int i = 0; i < 12; i++) {
                    GpuTexture gpuTexture = RenderSystem.getShaderTexture(i);
                    if (gpuTexture != null) {
                        if (((VkGpuTexture)gpuTexture).getVulkanImage() == null)
                            throw new NullPointerException();

                        renderPass.bindSampler("Sampler" + i, gpuTexture);
                        VTextureSelector.bindTexture(i, ((VkGpuTexture)gpuTexture).getVulkanImage());
                    }
                }

                VRenderSystem.applyModelViewMatrix(RenderSystem.getModelViewMatrix());
                VRenderSystem.applyProjectionMatrix(RenderSystem.getProjectionMatrix());
                VRenderSystem.calculateMVP();

                EGlProgram glProgram = ExtendedRenderPipeline.of(renderPipeline).getProgram();

                class_1041 window = class_310.method_1551().method_22683();
                glProgram.setDefaultUniforms(
                        renderPipeline.getVertexFormatMode(),
                        RenderSystem.getModelViewMatrix(),
                        RenderSystem.getProjectionMatrix(),
                        (float)window.method_4489(),
                        (float)window.method_4506()
                );

                commandEncoder.applyPipelineState(renderPipeline);

                Pipeline pipeline = ExtendedRenderPipeline.of(renderPipeline).getPipeline();
                VRenderSystem.setPrimitiveTopologyGL(GlConst.toGl(meshData.method_60822().comp_752()));

                Renderer renderer = Renderer.getInstance();
                renderer.bindGraphicsPipeline((GraphicsPipeline) pipeline);
                VTextureSelector.bindShaderTextures(pipeline);
                renderer.uploadAndBindUBOs(pipeline);

                Renderer.getDrawer().draw(meshData.method_60818(), meshData.method_60821(), meshData.method_60822().comp_752(), meshData.method_60822().comp_749(), meshData.method_60822().comp_750());
            }
        } catch (Throwable var14) {
            if (meshData != null) {
                try {
                    meshData.close();
                } catch (Throwable var11) {
                    var14.addSuppressed(var11);
                }
            }

            throw var14;
        }

        if (meshData != null) {
            meshData.close();
        }

        ((class_1921.class_4687)(Object)(this)).method_23518();
    }

}
