package net.vulkanmod.mixin.render.entity;

import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4604;
import net.minecraft.class_897;
import net.vulkanmod.Initializer;
import net.vulkanmod.render.chunk.RenderSection;
import net.vulkanmod.render.chunk.WorldRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_897.class)
public class EntityRendererM<T extends class_1297> {

//    /**
//     * @author
//     * @reason
//     */
//    @Overwrite
//    public boolean shouldRender(T entity, Frustum frustum, double d, double e, double f) {
//        if (!entity.shouldRender(d, e, f)) {
//            return false;
//        } else if (entity.noCulling) {
//            return true;
//        } else {
//            AABB aABB = entity.getBoundingBoxForCulling().inflate(0.5);
//            if (aABB.hasNaN() || aABB.getSize() == 0.0) {
//                aABB = new AABB(entity.getX() - 2.0, entity.getY() - 2.0, entity.getZ() - 2.0, entity.getX() + 2.0, entity.getY() + 2.0, entity.getZ() + 2.0);
//            }
//
////            WorldRenderer.getInstance().getSectionGrid().getSectionAtBlockPos((int) entity.getX(), (int) entity.getY(), (int) entity.getZ());
//            WorldRenderer worldRenderer = WorldRenderer.getInstance();
////            return (worldRenderer.getLastFrame() == worldRenderer.getSectionGrid().getSectionAtBlockPos(entity.getBlockX(), entity.getBlockY(), entity.getBlockZ()).getLastFrame());
//
//            return frustum.isVisible(aABB);
//        }
//    }

    @Redirect(method = "shouldRender", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/culling/Frustum;isVisible(Lnet/minecraft/world/phys/AABB;)Z"))
    private boolean isVisible(class_4604 frustum, class_238 aABB) {
        if(Initializer.CONFIG.entityCulling) {
            WorldRenderer worldRenderer = WorldRenderer.getInstance();

            class_243 pos = aABB.method_1005();

            RenderSection section = worldRenderer.getSectionGrid().getSectionAtBlockPos((int) pos.method_10216(), (int) pos.method_10214(), (int) pos.method_10215());

            if(section == null)
                return frustum.method_23093(aABB);

            return worldRenderer.getLastFrame() == section.getLastFrame();
        } else {
            return frustum.method_23093(aABB);
        }

    }
}
