package net.vulkanmod.mixin.render.entity;

import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_8921;
import net.minecraft.class_898;
import net.minecraft.class_9779;
import net.minecraft.class_9922;
import net.vulkanmod.Initializer;
import net.vulkanmod.render.chunk.WorldRenderer;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.Map;

@Mixin(class_761.class)
public class LevelRendererM {

    @Shadow @Final private class_898 entityRenderDispatcher;
    @Shadow @Final private class_310 minecraft;

    @Unique private Object2ReferenceOpenHashMap<class_4597, Map<Class<? extends class_1297>, ObjectArrayList<class_1297>>> bufferSourceMap = new Object2ReferenceOpenHashMap<>();
    @Unique boolean managed;

    @Inject(method = "renderLevel",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/client/renderer/LevelRenderer;setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V",
                    shift = At.Shift.AFTER)
    )
    private void clearMap(class_9922 graphicsResourceAllocator, class_9779 deltaTracker, boolean bl,
                          class_4184 camera, class_757 gameRenderer, Matrix4f matrix4f, Matrix4f matrix4f2,
                          CallbackInfo ci) {
        for (var bufferSource : this.bufferSourceMap.keySet()) {
            var entityMap = this.bufferSourceMap.get(bufferSource);
            entityMap.clear();
        }

        this.managed = true;
    }

    /**
     * @author
     * @reason
     */
    @Overwrite
    private void renderEntity(class_1297 entity, double d, double e, double f, float partialTicks, class_4587 poseStack, class_4597 multiBufferSource) {
        if (!Initializer.CONFIG.entityCulling || !this.managed) {
            double h = class_3532.method_16436(partialTicks, entity.field_6038, entity.method_23317());
            double i = class_3532.method_16436(partialTicks, entity.field_5971, entity.method_23318());
            double j = class_3532.method_16436(partialTicks, entity.field_5989, entity.method_23321());
            this.entityRenderDispatcher.method_62424(entity, h - d, i - e, j - f, partialTicks, poseStack, multiBufferSource, this.entityRenderDispatcher.method_23839(entity, partialTicks));
            return;
        }

        var entityClass = entity.getClass();

        var entityMap = this.bufferSourceMap.computeIfAbsent(multiBufferSource, bufferSource -> new Object2ReferenceOpenHashMap<>());
        var list = entityMap.computeIfAbsent(entityClass, k -> new ObjectArrayList<>());
        list.add(entity);
    }

    @Inject(method = "renderEntities", at = @At("RETURN"))
    private void renderEntities(class_4587 poseStack, class_4597.class_4598 bufferSource1, class_4184 camera, class_9779 deltaTracker, List<class_1297> entityList, CallbackInfo ci) {
        if (!Initializer.CONFIG.entityCulling)
            return;

        class_243 cameraPos = WorldRenderer.getCameraPos();
        class_8921 tickRateManager = this.minecraft.field_1687.method_54719();

//        PoseStack poseStack = new PoseStack();

        for (var bufferSource : this.bufferSourceMap.keySet()) {
            var entityMap = this.bufferSourceMap.get(bufferSource);

            for (var list : entityMap.values()) {
                for (class_1297 entity : list) {
                    float partialTicks = deltaTracker.method_60637(!tickRateManager.method_54746(entity));

                    double h = class_3532.method_16436(partialTicks, entity.field_6038, entity.method_23317());
                    double i = class_3532.method_16436(partialTicks, entity.field_5971, entity.method_23318());
                    double j = class_3532.method_16436(partialTicks, entity.field_5989, entity.method_23321());
                    this.entityRenderDispatcher.method_62424(entity, h - cameraPos.field_1352, i - cameraPos.field_1351, j - cameraPos.field_1350, partialTicks, poseStack, bufferSource, this.entityRenderDispatcher.method_23839(entity, partialTicks));
                }
            }
        }

        this.managed = false;
    }
}
