package net.vulkanmod.mixin.render.particle;

import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_761;
import net.vulkanmod.interfaces.ExtendedVertexBuilder;
import net.vulkanmod.render.chunk.RenderSection;
import net.vulkanmod.render.chunk.WorldRenderer;
import net.vulkanmod.vulkan.VRenderSystem;
import net.vulkanmod.vulkan.util.ColorUtil;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(class_3940.class)
public abstract class SingleQuadParticleM extends class_703 {

    @Shadow protected float quadSize;

    @Unique private final Quaternionf quaternionf = new Quaternionf();
    @Unique private final Vector3f vector3f = new Vector3f();

    @Shadow protected abstract float getU0();
    @Shadow protected abstract float getU1();
    @Shadow protected abstract float getV0();
    @Shadow protected abstract float getV1();

    @Shadow public abstract float getQuadSize(float f);

    @Shadow public abstract class_3940.class_8981 getFacingCameraMode();

    protected SingleQuadParticleM(class_638 clientLevel, double d, double e, double f, double g, double h, double i) {
        super(clientLevel, d, e, f, g, h, i);
        this.quadSize = 0.1F * (this.field_3840.method_43057() * 0.5F + 0.5F) * 2.0F;
    }

    /**
     * @author
     * @reason
     */
    @Overwrite
    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float f) {
        double lx = (class_3532.method_16436(f, this.field_3858, this.field_3874));
        double ly = (class_3532.method_16436(f, this.field_3838, this.field_3854));
        double lz = (class_3532.method_16436(f, this.field_3856, this.field_3871));

        if (cull(WorldRenderer.getInstance(), lx, ly, lz))
            return;

        class_243 vec3 = camera.method_19326();
        float offsetX = (float) (lx - vec3.method_10216());
        float offsetY = (float) (ly - vec3.method_10214());
        float offsetZ = (float) (lz - vec3.method_10215());

        quaternionf.identity();
        this.getFacingCameraMode().setRotation(quaternionf, camera, f);
        if (this.field_3839 != 0.0F) {
            quaternionf.rotateZ(class_3532.method_16439(f, this.field_3857, this.field_3839));
        }

        this.renderRotatedQuad(vertexConsumer, quaternionf, offsetX, offsetY, offsetZ, f);
    }

    @Unique
    private void renderRotatedQuad(class_4588 vertexConsumer, Quaternionf quaternionf, float x, float y, float z, float f) {
        float j = this.getQuadSize(f);
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int light = this.method_3068(f);

        ExtendedVertexBuilder vertexBuilder = (ExtendedVertexBuilder)vertexConsumer;
        int packedColor = ColorUtil.RGBA.pack(this.field_3861, this.field_3842, this.field_3859, this.field_3841);

        this.renderVertex(vertexBuilder, quaternionf, x, y, z,  1.0F, -1.0F, j, u1, v1, packedColor, light);
        this.renderVertex(vertexBuilder, quaternionf, x, y, z,  1.0F,  1.0F, j, u1, v0, packedColor, light);
        this.renderVertex(vertexBuilder, quaternionf, x, y, z, -1.0F,  1.0F, j, u0, v0, packedColor, light);
        this.renderVertex(vertexBuilder, quaternionf, x, y, z, -1.0F, -1.0F, j, u0, v1, packedColor, light);
    }

    @Unique
    private void renderVertex(
            ExtendedVertexBuilder vertexConsumer, Quaternionf quaternionf, float x, float y, float z, float i, float j, float k, float u, float v, int color, int light
    ) {
        vector3f.set(i, j, 0.0f)
                .rotate(quaternionf)
                .mul(k)
                .add(x, y, z);

        vertexConsumer.vertex(vector3f.x(), vector3f.y(), vector3f.z(), u, v, color, light);
    }

    protected int method_3068(float f) {
        class_2338 blockPos = class_2338.method_49637(this.field_3874, this.field_3854, this.field_3871);
        return this.field_3851.method_22340(blockPos) ? class_761.method_23794(this.field_3851, blockPos) : 0;
    }

    private boolean cull(WorldRenderer worldRenderer, double x, double y, double z) {
        RenderSection section = worldRenderer.getSectionGrid().getSectionAtBlockPos((int) x, (int) y, (int) z);
        return section != null && section.getLastFrame() != worldRenderer.getLastFrame();
    }

    @Override
    public class_3999 method_18122() {
        return null;
    }
}
