package net.vulkanmod.mixin.render.target;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import net.minecraft.class_276;
import net.minecraft.class_6364;
import net.vulkanmod.vulkan.Renderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(class_6364.class)
public class MainTargetMixin extends class_276 {

    public MainTargetMixin(boolean useDepth) {
        super("Main", useDepth);
    }

    /**
     * @author
     * @reason
     */
    @Overwrite
    private void createFrameBuffer(int width, int height) {
        this.field_1480 = width;
        this.field_1477 = height;
        this.field_1482 = width;
        this.field_1481 = height;
    }

    @Override
    public void method_1231(int i, int j) {
        RenderSystem.assertOnRenderThread();
        int k = RenderSystem.getDevice().getMaxTextureSize();
        if (i > 0 && i <= k && j > 0 && j <= k) {
            this.field_1480 = i;
            this.field_1477 = j;
            this.field_1482 = i;
            this.field_1481 = j;
            if (this.field_1478) {
                this.field_56739 = RenderSystem.getDevice().createTexture(() -> this.field_56738 + " / Depth", TextureFormat.DEPTH32, i, j, 1);
                this.field_56739.setTextureFilter(FilterMode.NEAREST, false);
                this.field_56739.setAddressMode(AddressMode.CLAMP_TO_EDGE);
            }

            this.field_1475 = RenderSystem.getDevice().createTexture(() -> this.field_56738 + " / Color", TextureFormat.RGBA8, i, j, 1);
            this.field_1475.setAddressMode(AddressMode.CLAMP_TO_EDGE);
            this.method_1232(FilterMode.NEAREST, true);
        } else {
            throw new IllegalArgumentException("Window " + i + "x" + j + " size out of bounds (max. size: " + k + ")");
        }
    }

    private void method_1232(FilterMode filterMode, boolean bl) {
        if (this.field_1475 == null) {
            throw new IllegalStateException("Can't change filter mode, color texture doesn't exist yet");
        } else {
            if (bl || filterMode != this.field_1483) {
                this.field_1483 = filterMode;
                this.field_1475.setTextureFilter(filterMode, false);
            }
        }
    }

    @Override
    public GpuTexture method_30277() {
        return Renderer.getInstance().getMainPass().getColorAttachment();
    }
}
