package net.vulkanmod.mixin.texture.update;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1011;
import net.minecraft.class_10209;
import net.minecraft.class_1043;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.vulkanmod.gl.VkGlTexture;
import net.vulkanmod.mixin.texture.image.NativeImageAccessor;
import net.vulkanmod.render.engine.VkGpuTexture;
import net.vulkanmod.render.texture.ImageUploadHelper;
import net.vulkanmod.vulkan.queue.CommandPool;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_765.class)
public class MLightTexture {
    @Shadow @Final private class_310 minecraft;
    @Shadow @Final private class_757 renderer;

    @Shadow private boolean updateLightTexture;
    @Shadow private float blockLightRedFlicker;

    private class_1043 lightTexture;
    private class_1011 lightPixels;

    private Vector3f[] tempVecs;

    @Inject(method = "<init>", at = @At("RETURN"))
    private void onInit(class_757 gameRenderer, class_310 minecraft, CallbackInfo ci) {
        initLightMap();

        this.tempVecs = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f()};
    }

    private void initLightMap() {
        this.lightTexture = new class_1043("Light Texture", 16, 16, false);
        this.lightPixels = this.lightTexture.method_4525();

        for(int i = 0; i < 16; ++i) {
            for(int j = 0; j < 16; ++j) {
                this.lightPixels.method_61941(j, i, 0xFFFFFFFF);
            }
        }

        this.lightTexture.method_4524();
    }

    /**
     * @author
     * @reason
     */
    @Overwrite
    public void turnOnLightLayer() {
        RenderSystem.setShaderTexture(2, this.lightTexture.method_68004());
    }

    @SuppressWarnings("UnreachableCode")
    @Inject(method = "updateLightTexture", at = @At("HEAD"), cancellable = true)
    public void updateLightTexture(float partialTicks, CallbackInfo ci) {
        if (this.updateLightTexture) {
            this.updateLightTexture = false;

            class_3695 profilerFiller = class_10209.method_64146();
            profilerFiller.method_15396("lightTex");

            // TODO: Other mods might be changing lightmap behaviour, we can't be aware of that here

            class_638 clientLevel = this.minecraft.field_1687;
            if (clientLevel != null) {
                float skyDarken = clientLevel.method_23783(1.0F);
                float skyFlashTime;
                if (clientLevel.method_23789() > 0) {
                    skyFlashTime = 1.0F;
                } else {
                    skyFlashTime = skyDarken * 0.95F + 0.05F;
                }

                float darknessEffectScale = this.minecraft.field_1690.method_42472().method_41753().floatValue();
                float darknessGamma = this.getDarknessGamma(partialTicks) * darknessEffectScale;
                float darknessScale = this.calculateDarknessScale(this.minecraft.field_1724, darknessGamma, partialTicks) * darknessEffectScale;
                float waterVision = this.minecraft.field_1724.method_3140();
                float nightVisionFactor;
                if (this.minecraft.field_1724.method_6059(class_1294.field_5925)) {
                    nightVisionFactor = class_757.method_3174(this.minecraft.field_1724, partialTicks);
                } else if (waterVision > 0.0F && this.minecraft.field_1724.method_6059(class_1294.field_5927)) {
                    nightVisionFactor = waterVision;
                } else {
                    nightVisionFactor = 0.0F;
                }

//                Vector3f skyLightColor = new Vector3f(skyDarken, skyDarken, 1.0F).lerp(new Vector3f(1.0F, 1.0F, 1.0F), 0.35F);
                skyDarken = lerp(skyDarken, 1.0f, 0.35f);
                Vector3f skyLightColor = this.tempVecs[0].set(skyDarken, skyDarken, 1.0F);
                float redFlicker = this.blockLightRedFlicker + 1.5F;
                Vector3f lightColor = this.tempVecs[1];

                float gamma = this.minecraft.field_1690.method_42473().method_41753().floatValue();
                float darkenWorldAmount = this.renderer.method_3195(partialTicks);
                boolean forceBrightLightmap = clientLevel.method_28103().method_28114();
                float ambientLight = clientLevel.method_8597().comp_656();

                long ptr = ((NativeImageAccessor)(Object)this.lightPixels).getPixels();
                int width = this.lightPixels.method_4307();

                Vector3f tVec3f = this.tempVecs[2];

                for(int y = 0; y < 16; ++y) {
                    float brY = getBrightness(ambientLight, y) * skyFlashTime;

                    for(int x = 0; x < 16; ++x) {
                        float brX = getBrightness(ambientLight, x) * redFlicker;
                        float t = brX * ((brX * 0.6F + 0.4F) * 0.6F + 0.4F);
                        float u = brX * (brX * brX * 0.6F + 0.4F);
                        lightColor.set(brX, t, u);

                        if (forceBrightLightmap) {
                            lightColor.lerp(tVec3f.set(0.99F, 1.12F, 1.0F), 0.25F);
                            clampColor(lightColor);
                        } else {
                            tVec3f.set(skyLightColor).mul(brY);
                            lightColor.add(tVec3f);

                            tVec3f.set(0.75F, 0.75F, 0.75F);
                            lightColor.lerp(tVec3f, 0.04F);

                            if (darkenWorldAmount > 0.0F) {
                                tVec3f.set(lightColor).mul(0.7F, 0.6F, 0.6F);
                                lightColor.lerp(tVec3f, darkenWorldAmount);
                            }
                        }

                        if (nightVisionFactor > 0.0F) {
                            // scale up uniformly until 1.0 is hit by one of the colors
                            float maxComponent = Math.max(lightColor.x(), Math.max(lightColor.y(), lightColor.z()));
                            if (maxComponent < 1.0F) {
                                float brightColor = 1.0F / maxComponent;
                                tVec3f.set(lightColor).mul(brightColor);
                                lightColor.lerp(tVec3f, nightVisionFactor);
                            }
                        }

                        if (!forceBrightLightmap) {
                            lightColor.add(-darknessScale, -darknessScale, -darknessScale);
                            clampColor(lightColor);
                        }

                        tVec3f.set(this.notGamma(lightColor.x), this.notGamma(lightColor.y), this.notGamma(lightColor.z));
                        lightColor.lerp(tVec3f, Math.max(0.0F, gamma - darknessGamma));

                        lightColor.lerp(tVec3f.set(0.75F, 0.75F, 0.75F), 0.04F);
                        clampColor(lightColor);

                        lightColor.mul(255.0F);
                        int r = (int)lightColor.x();
                        int g = (int)lightColor.y();
                        int b = (int)lightColor.z();

                        MemoryUtil.memPutInt(ptr + (((long) y * width + x) * 4L), 0xFF000000 | b << 16 | g << 8 | r);
                    }
                }

                CommandPool.CommandBuffer commandBuffer = ImageUploadHelper.INSTANCE.getOrStartCommandBuffer();
                this.lightTexture.method_4524();

                try (MemoryStack stack = MemoryStack.stackPush()) {
                    VkGlTexture.getTexture(((VkGpuTexture)this.lightTexture.method_68004()).method_68427()).getVulkanImage().readOnlyLayout(stack, commandBuffer.getHandle());
                }

                profilerFiller.method_15407();
            }
        }

        ci.cancel();
    }

    @Unique
    private float getDarknessGamma(float f) {
        class_1293 mobEffectInstance = this.minecraft.field_1724.method_6112(class_1294.field_38092);
        return mobEffectInstance != null ? mobEffectInstance.method_55653(this.minecraft.field_1724, f) : 0.0F;
    }

    @Unique
    private float calculateDarknessScale(class_1309 livingEntity, float f, float g) {
        float h = 0.45F * f;
        return Math.max(0.0F, class_3532.method_15362(((float)livingEntity.field_6012 - g) * (float) Math.PI * 0.025F) * h);
    }

    @Unique
    private static float lerp(float a, float x, float t) {
        return (x - a) * t + a;
    }

    @Unique
    private static void clampColor(Vector3f vector3f) {
        vector3f.set(class_3532.method_15363(vector3f.x, 0.0F, 1.0F), class_3532.method_15363(vector3f.y, 0.0F, 1.0F), class_3532.method_15363(vector3f.z, 0.0F, 1.0F));
    }

    @Unique
    private float notGamma(float f) {
        float g = 1.0F - f;
        g = g * g;
        return 1.0F - g * g;
    }

    @Unique
    private static float getBrightness(float ambientLight, int i) {
        float f = (float)i / 15.0F;
        float g = f / (4.0F - 3.0F * f);
        return class_3532.method_16439(ambientLight, g, 1.0F);
    }

}
