package net.vulkanmod.mixin.texture.update;

import com.mojang.blaze3d.textures.GpuTexture;
import net.minecraft.class_7764;
import net.vulkanmod.render.texture.SpriteUpdateUtil;
import net.vulkanmod.vulkan.texture.VTextureSelector;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_7764.class_7765.class)
public class MSpriteContents {

    @Shadow int subFrame;
    @Shadow int frame;
    @Shadow @Final class_7764.class_5790 animationInfo;

    @Inject(method = "tickAndUpload", at = @At("HEAD"), cancellable = true)
    private void checkUpload(int i, int j, GpuTexture gpuTexture, CallbackInfo ci) {
        if (!SpriteUpdateUtil.doUploadFrame()) {
            // Update animations frames even if no upload is scheduled
            ++this.subFrame;
            class_7764.class_5791 frameInfo = this.animationInfo.field_28472.get(this.frame);
            if (this.subFrame >= frameInfo.comp_3446) {
                this.frame = (this.frame + 1) % this.animationInfo.field_28472.size();
                this.subFrame = 0;
            }

            ci.cancel();
        }
        else {
            SpriteUpdateUtil.addTransitionedLayout(VTextureSelector.getBoundTexture());
        }
    }
}
