package net.vulkanmod.render.chunk.build.frapi;

import java.util.HashMap;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.FabricBlockModelRenderer;
import net.fabricmc.fabric.api.renderer.v1.render.RenderLayerHelper;
import net.fabricmc.fabric.mixin.client.indigo.renderer.BlockRenderManagerAccessor;
import net.minecraft.class_10444;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_811;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.vulkanmod.render.chunk.build.frapi.material.MaterialFinderImpl;
import net.vulkanmod.render.chunk.build.frapi.mesh.MutableMeshImpl;
import net.vulkanmod.render.chunk.build.frapi.render.BlockRenderContext;
import net.vulkanmod.render.chunk.build.frapi.render.SimpleBlockRenderContext;

/**
 * The Fabric default renderer implementation. Supports all
 * features defined in the API except shaders and offers no special materials.
 */
public class VulkanModRenderer implements Renderer {
	public static final VulkanModRenderer INSTANCE = new VulkanModRenderer();

	public static final RenderMaterial STANDARD_MATERIAL = INSTANCE.materialFinder().find();

	static {
		INSTANCE.registerMaterial(RenderMaterial.STANDARD_ID, STANDARD_MATERIAL);
	}

	private final HashMap<class_2960, RenderMaterial> materialMap = new HashMap<>();

	private VulkanModRenderer() {}

	@Override
	public MutableMesh mutableMesh() {
		return new MutableMeshImpl();
	}

	@Override
	public MaterialFinder materialFinder() {
		return new MaterialFinderImpl();
	}

	@Override
	public RenderMaterial materialById(class_2960 id) {
		return materialMap.get(id);
	}

	@Override
	public boolean registerMaterial(class_2960 id, RenderMaterial material) {
		if (materialMap.containsKey(id)) return false;

		// cast to prevent acceptance of impostor implementations
		materialMap.put(id, material);
		return true;
	}

	@Override
	public void render(class_778 modelBlockRenderer, class_1920 blockAndTintGetter,
					   class_1087 blockStateModel, class_2680 blockState, class_2338 blockPos, class_4587 poseStack,
					   class_4597 multiBufferSource, boolean cull, long seed, int overlay) {
		BlockRenderContext.POOL.get().render(blockAndTintGetter, blockStateModel, blockState, blockPos, poseStack, multiBufferSource, cull, seed, overlay);
	}

	@Override
	public void render(class_4587.class_4665 pose, class_4597 multiBufferSource, class_1087 blockStateModel,
					   float v, float v1, float v2, int i, int i1, class_1920 blockAndTintGetter,
					   class_2338 blockPos, class_2680 blockState) {
		SimpleBlockRenderContext.POOL.get().bufferModel(pose, multiBufferSource, blockStateModel, v, v1, v2, i, i1, blockAndTintGetter, blockPos, blockState);
	}

	@Override
	public void renderBlockAsEntity(class_776 blockRenderDispatcher, class_2680 blockState,
									class_4587 poseStack, class_4597 multiBufferSource, int light, int overlay,
									class_1920 blockAndTintGetter, class_2338 pos) {
		class_2464 blockRenderType = blockState.method_26217();

		if (blockRenderType != class_2464.field_11455) {
			class_1087 model = blockRenderDispatcher.method_3349(blockState);
			int tint = ((BlockRenderManagerAccessor) blockRenderDispatcher).getBlockColors().method_1697(blockState, null, null, 0);
			float red = (tint >> 16 & 255) / 255.0F;
			float green = (tint >> 8 & 255) / 255.0F;
			float blue = (tint & 255) / 255.0F;
			FabricBlockModelRenderer.render(poseStack.method_23760(), layer -> multiBufferSource.getBuffer(RenderLayerHelper.getEntityBlockLayer(layer)), model, red, green, blue, light, overlay, blockAndTintGetter, pos, blockState);
			((BlockRenderManagerAccessor) blockRenderDispatcher).getBlockEntityModelsGetter().get().method_65535(blockState.method_26204(), class_811.field_4315, poseStack, multiBufferSource, light, overlay);
		}
	}

	@Override
	public QuadEmitter getLayerRenderStateEmitter(class_10444.class_10446 layerRenderState) {
		return null;
	}
}
