package net.vulkanmod.render.engine;

import com.mojang.blaze3d.opengl.GlStateManager;
import net.minecraft.class_9848;
import net.vulkanmod.gl.VkGlFramebuffer;
import net.vulkanmod.vulkan.Renderer;
import net.vulkanmod.vulkan.VRenderSystem;
import org.lwjgl.opengl.GL33;

public class VkFbo {
    final int glId;
    final VkGpuTexture colorAttachment;
    final VkGpuTexture depthAttachment;

    int clear = 0;
    int clearColor = 0;
    float clearDepth = 0.0f;

    protected VkFbo(VkGpuTexture colorAttachment, VkGpuTexture depthAttachment) {
        this.glId = GlStateManager.glGenFramebuffers();
        this.colorAttachment = colorAttachment;
        this.depthAttachment = depthAttachment;

        // Direct access
        VkGlFramebuffer fbo = VkGlFramebuffer.getFramebuffer(this.glId);

        fbo.setAttachmentTexture(GL33.GL_COLOR_ATTACHMENT0, colorAttachment.field_57882);
        if (depthAttachment != null) {
            fbo.setAttachmentTexture(GL33.GL_DEPTH_ATTACHMENT, depthAttachment.field_57882);
        }
    }

    protected void bind() {
        VkGlFramebuffer.bindFramebuffer(GL33.GL_FRAMEBUFFER, this.glId);

        clearAttachments();
    }

    protected void clearAttachments() {
        if (clear != 0) {
            VRenderSystem.clearDepth(clearDepth);
            VRenderSystem.setClearColor(class_9848.method_65101(clearColor), class_9848.method_65102(clearColor), class_9848.method_65103(clearColor), class_9848.method_65100(clearColor));
            Renderer.clearAttachments(clear);

            clear = 0;
        }
    }

    protected void close() {
        VkGlFramebuffer.deleteFramebuffer(this.glId);
    }

    public boolean needsClear() {
        return this.clear != 0;
    }
}
