package net.vulkanmod.render.model;

import org.joml.Matrix4f;
import org.joml.Vector3f;

import java.util.Set;
import net.minecraft.class_2350;
import net.minecraft.class_630;

public class CubeModel {

    private class_630.class_593[] polygons = new class_630.class_593[6];
    public float minX;
    public float minY;
    public float minZ;
    public float maxX;
    public float maxY;
    public float maxZ;

    Vector3f[] vertices;
    Vector3f[] transformed = new Vector3f[8];

    public void setVertices(int i, int j, float f, float g, float h, float k, float l, float m, float n, float o, float p, boolean bl, float q, float r, Set<class_2350> set) {
        this.minX = f;
        this.minY = g;
        this.minZ = h;
        this.maxX = f + k;
        this.maxY = g + l;
        this.maxZ = h + m;
        this.polygons = new class_630.class_593[set.size()];
        float s = maxX;
        float t = maxY;
        float u = maxZ;
        f -= n;
        g -= o;
        h -= p;
        s += n;
        t += o;
        u += p;
        if (bl) {
            float v = s;
            s = f;
            f = v;
        }

        this.vertices = new Vector3f[]{
                new Vector3f(f, g, h),
                new Vector3f(s, g, h),
                new Vector3f(s, t, h),
                new Vector3f(f, t, h),
                new Vector3f(f, g, u),
                new Vector3f(s, g, u),
                new Vector3f(s, t, u),
                new Vector3f(f, t, u)
        };

        for (int i1 = 0; i1 < 8; i1++) {
            //pre-divide all vertices once
            this.vertices[i1].div(16.0f);
            this.transformed[i1] = new Vector3f(0.0f);
        }

        class_630.class_618 vertex1 = new class_630.class_618(transformed[0], 0.0F, 0.0F);
        class_630.class_618 vertex2 = new class_630.class_618(transformed[1], 0.0F, 8.0F);
        class_630.class_618 vertex3 = new class_630.class_618(transformed[2], 8.0F, 8.0F);
        class_630.class_618 vertex4 = new class_630.class_618(transformed[3], 8.0F, 0.0F);
        class_630.class_618 vertex5 = new class_630.class_618(transformed[4], 0.0F, 0.0F);
        class_630.class_618 vertex6 = new class_630.class_618(transformed[5], 0.0F, 8.0F);
        class_630.class_618 vertex7 = new class_630.class_618(transformed[6], 8.0F, 8.0F);
        class_630.class_618 vertex8 = new class_630.class_618(transformed[7], 8.0F, 0.0F);

        float w = (float)i;
        float x = (float)i + m;
        float y = (float)i + m + k;
        float z = (float)i + m + k + k;
        float aa = (float)i + m + k + m;
        float ab = (float)i + m + k + m + k;
        float ac = (float)j;
        float ad = (float)j + m;
        float ae = (float)j + m + l;
        int idx = 0;
        if (set.contains(class_2350.field_11033)) {
            this.polygons[idx++] = new class_630.class_593(new class_630.class_618[]{vertex6, vertex5, vertex1, vertex2}, x, ac, y, ad, q, r, bl, class_2350.field_11033);
        }

        if (set.contains(class_2350.field_11036)) {
            this.polygons[idx++] = new class_630.class_593(new class_630.class_618[]{vertex3, vertex4, vertex8, vertex7}, y, ad, z, ac, q, r, bl, class_2350.field_11036);
        }

        if (set.contains(class_2350.field_11039)) {
            this.polygons[idx++] = new class_630.class_593(new class_630.class_618[]{vertex1, vertex5, vertex8, vertex4}, w, ad, x, ae, q, r, bl, class_2350.field_11039);
        }

        if (set.contains(class_2350.field_11043)) {
            this.polygons[idx++] = new class_630.class_593(new class_630.class_618[]{vertex2, vertex1, vertex4, vertex3}, x, ad, y, ae, q, r, bl, class_2350.field_11043);
        }

        if (set.contains(class_2350.field_11034)) {
            this.polygons[idx++] = new class_630.class_593(new class_630.class_618[]{vertex6, vertex2, vertex3, vertex7}, y, ad, aa, ae, q, r, bl, class_2350.field_11034);
        }

        if (set.contains(class_2350.field_11035)) {
            this.polygons[idx] = new class_630.class_593(new class_630.class_618[]{vertex5, vertex6, vertex7, vertex8}, aa, ad, ab, ae, q, r, bl, class_2350.field_11035);
        }
    }

    public void transformVertices(Matrix4f matrix) {
        //Transform original vertices and store them
        for(int i = 0; i < 8; ++i) {
            this.vertices[i].mulPosition(matrix, this.transformed[i]);
        }
    }

    public class_630.class_593[] getPolygons() { return this.polygons; }
}
