/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crystalcraftunlimitedjava.item;

import net.mcreator.crystalcraftunlimitedjava.init.CrystalcraftUnlimitedJavaModItems;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public abstract class GarnetArmorItem
extends ArmorItem {
    public GarnetArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 18;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{2, 5, 6, 2})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 9;
            }

            public SoundEvent getEquipSound() {
                return SoundEvents.EMPTY;
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CrystalcraftUnlimitedJavaModItems.GARNET.get())});
            }

            public String getName() {
                return "garnet_armor";
            }

            public float getToughness() {
                return 0.2f;
            }

            public float getKnockbackResistance() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends GarnetArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/lololololololololol__layer_1.png";
        }
    }

    public static class Leggings
    extends GarnetArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/lololololololololol__layer_2.png";
        }
    }

    public static class Chestplate
    extends GarnetArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/lololololololololol__layer_1.png";
        }
    }

    public static class Helmet
    extends GarnetArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/lololololololololol__layer_1.png";
        }
    }
}

