/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crystalcraftunlimitedjava.item;

import net.mcreator.crystalcraftunlimitedjava.init.CrystalcraftUnlimitedJavaModItems;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public abstract class PurpleDiamondArmorItem
extends ArmorItem {
    public PurpleDiamondArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 44;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{4, 7, 9, 4})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 20;
            }

            public SoundEvent getEquipSound() {
                return SoundEvents.EMPTY;
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CrystalcraftUnlimitedJavaModItems.PURPLE_DIAMOND.get())});
            }

            public String getName() {
                return "purple_diamond_armor";
            }

            public float getToughness() {
                return 2.0f;
            }

            public float getKnockbackResistance() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends PurpleDiamondArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/pa_purple_diamond_helmet-1.pnglayer_1_layer_1.png";
        }
    }

    public static class Leggings
    extends PurpleDiamondArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/pa_purple_diamond_helmet-1.pnglayer_1_layer_2.png";
        }
    }

    public static class Chestplate
    extends PurpleDiamondArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/pa_purple_diamond_helmet-1.pnglayer_1_layer_1.png";
        }
    }

    public static class Helmet
    extends PurpleDiamondArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/pa_purple_diamond_helmet-1.pnglayer_1_layer_1.png";
        }
    }
}

