/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crystalcraftunlimitedjava.item;

import net.mcreator.crystalcraftunlimitedjava.init.CrystalcraftUnlimitedJavaModItems;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public abstract class NeonMeteoriteArmorItem
extends ArmorItem {
    public NeonMeteoriteArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 1000;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{100, 169, 180, 140})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 20;
            }

            public SoundEvent getEquipSound() {
                return SoundEvents.EMPTY;
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CrystalcraftUnlimitedJavaModItems.NEON_METEORITE.get()), new ItemStack((ItemLike)CrystalcraftUnlimitedJavaModItems.NEON_METEORITE_SCRAP.get())});
            }

            public String getName() {
                return "neon_meteorite_armor";
            }

            public float getToughness() {
                return 5.5f;
            }

            public float getKnockbackResistance() {
                return 0.1f;
            }
        }, type, properties);
    }

    public static class Boots
    extends NeonMeteoriteArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties().fireResistant());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/001_armor_template_-1.png_layer_1.png";
        }
    }

    public static class Leggings
    extends NeonMeteoriteArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties().fireResistant());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/001_armor_template_-1.png_layer_2.png";
        }
    }

    public static class Chestplate
    extends NeonMeteoriteArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().fireResistant());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/001_armor_template_-1.png_layer_1.png";
        }
    }

    public static class Helmet
    extends NeonMeteoriteArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties().fireResistant());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/001_armor_template_-1.png_layer_1.png";
        }
    }
}

