/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crystalcraftunlimitedjava.item;

import java.util.List;
import net.mcreator.crystalcraftunlimitedjava.init.CrystalcraftUnlimitedJavaModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class OrichalcumArmorItem
extends ArmorItem {
    public OrichalcumArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 150;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{69, 70, 79, 60})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 90;
            }

            public SoundEvent getEquipSound() {
                return SoundEvents.EMPTY;
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CrystalcraftUnlimitedJavaModItems.ORICHALCUM.get())});
            }

            public String getName() {
                return "orichalcum_armor";
            }

            public float getToughness() {
                return 0.0f;
            }

            public float getKnockbackResistance() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends OrichalcumArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.literal((String)"Now I shall finally tell the tale of my first battle here..."));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/pa_orichalcum_chestplate-1.png__layer_1.png";
        }
    }

    public static class Leggings
    extends OrichalcumArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.literal((String)"Don't worry... I'll end this. Once and for all."));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/pa_orichalcum_chestplate-1.png__layer_2.png";
        }
    }

    public static class Chestplate
    extends OrichalcumArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.literal((String)"So much for this world's monsters! Anybody else?"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/pa_orichalcum_chestplate-1.png__layer_1.png";
        }
    }

    public static class Helmet
    extends OrichalcumArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.literal((String)"My past is not a memory."));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/pa_orichalcum_chestplate-1.png__layer_1.png";
        }
    }
}

