/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.crystalcraftunlimitedjava.item;

import java.util.List;
import net.mcreator.crystalcraftunlimitedjava.init.CrystalcraftUnlimitedJavaModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class RareTanzaniteArmorItem
extends ArmorItem {
    public RareTanzaniteArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.getSlot().getIndex()] * 25;
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return (new int[]{8, 10, 11, 9})[type.getSlot().getIndex()];
            }

            public int getEnchantmentValue() {
                return 9;
            }

            public SoundEvent getEquipSound() {
                return SoundEvents.EMPTY;
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CrystalcraftUnlimitedJavaModItems.RARE_TANZANITE.get())});
            }

            public String getName() {
                return "rare_tanzanite_armor";
            }

            public float getToughness() {
                return 4.0f;
            }

            public float getKnockbackResistance() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends RareTanzaniteArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.literal((String)"A rare version of Tanzanite Boots"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/pa_rare_tanzanite_chestplate-1.png_layer_1.png";
        }
    }

    public static class Leggings
    extends RareTanzaniteArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.literal((String)"A rare version of Tanzanite Leggings"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/pa_rare_tanzanite_chestplate-1.png_layer_2.png";
        }
    }

    public static class Chestplate
    extends RareTanzaniteArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.literal((String)"A rare version of a Tanzanite Chestplate"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/pa_rare_tanzanite_chestplate-1.png_layer_1.png";
        }
    }

    public static class Helmet
    extends RareTanzaniteArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, level, list, flag);
            list.add((Component)Component.literal((String)"A rare version of a Tanzanite Helmet"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "crystalcraft_unlimited_java:textures/models/armor/pa_rare_tanzanite_chestplate-1.png_layer_1.png";
        }
    }
}

