/*
 * Decompiled with CFR 0.152.
 */
package tech.kd_gaming1.heartless_pursuit;

import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import tech.kd_gaming1.heartless_pursuit.config.HeartlessPursuitConfig;

public class TabListManager {
    private static final HashMap<UUID, Integer> lastLevelCache = new HashMap();

    public static void register() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            TabListManager.updatePlayerTabInfo(player);
            lastLevelCache.put(player.method_5667(), player.field_7520);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> lastLevelCache.remove(handler.field_14140.method_5667()));
    }

    public static void onXpLevelChange(class_3222 player) {
        int currentLevel = player.field_7520;
        UUID playerUUID = player.method_5667();
        if (!lastLevelCache.containsKey(playerUUID) || lastLevelCache.get(playerUUID) != currentLevel) {
            lastLevelCache.put(playerUUID, currentLevel);
            TabListManager.updatePlayerTabInfo(player);
        }
    }

    private static void updatePlayerTabInfo(class_3222 player) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        class_2995 scoreboard = server.method_3845();
        String playerName = player.method_5477().getString();
        String teamName = "xp_" + player.method_5667().toString().substring(0, 8);
        if (!HeartlessPursuitConfig.SHOW_TAB_INDICATOR) {
            class_268 team = scoreboard.method_1153(teamName);
            if (team != null) {
                team.method_1139((class_2561)class_2561.method_43470((String)""));
            }
            scoreboard.method_1195(playerName);
            return;
        }
        class_268 team = scoreboard.method_1153(teamName);
        if (team == null) {
            team = scoreboard.method_1171(teamName);
        }
        String xpInfo = " \u00a7a[Level: " + player.field_7520 + "]";
        team.method_1139((class_2561)class_2561.method_43470((String)xpInfo));
        scoreboard.method_1195(playerName);
        scoreboard.method_1172(playerName, team);
    }
}

