/*
 * Decompiled with CFR 0.152.
 */
package tech.kd_gaming1.heartless_pursuit;

import net.minecraft.class_2561;
import net.minecraft.class_3222;
import tech.kd_gaming1.heartless_pursuit.config.HeartlessPursuitConfig;
import tech.kd_gaming1.heartless_pursuit.event.PlayerKillPlayerCallback;

public class PlayerStealXP {
    public static void init() {
        PlayerKillPlayerCallback.EVENT.register((killer, victim) -> {
            if (HeartlessPursuitConfig.DISABLE_XP_STEAL) {
                return;
            }
            int victimLevel = victim.field_7520;
            int totalXP = PlayerStealXP.getTotalXP(victim, victimLevel);
            killer.method_7255(totalXP);
            victim.method_14252(0);
            victim.method_14228(0);
            if (HeartlessPursuitConfig.SHOW_XP_MESSAGES) {
                killer.method_64398((class_2561)class_2561.method_43470((String)("You stole " + victimLevel + " levels from " + victim.method_5477().getString())));
                victim.method_64398((class_2561)class_2561.method_43470((String)("Your levels were stolen by " + killer.method_5477().getString())));
            }
        });
    }

    private static int getTotalXP(class_3222 victim, int victimLevel) {
        int victimProgress = (int)(victim.field_7510 * (float)victim.method_7349());
        int totalXP = PlayerStealXP.calculateTotalXP(victimLevel) + victimProgress;
        double stealPercentage = HeartlessPursuitConfig.XP_STEAL_PERCENTAGE;
        if (stealPercentage < 0.0 || stealPercentage > 100.0) {
            stealPercentage = 50.0;
        }
        totalXP = (int)((double)totalXP * (stealPercentage / 100.0));
        totalXP = Math.max(totalXP, 0);
        return totalXP;
    }

    private static int calculateTotalXP(int level) {
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }
}

