/*
 * Decompiled with CFR 0.152.
 */
package com.legendaryspy.connectedcore.config;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.slf4j.Logger;

public final class ConnectedCoreConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String FILE_NAME = "connected-core.properties";
    private static final String FIREWORK_KEY = "FireworkBoosting";
    private final Path configPath;
    private boolean fireworkBoosting;

    private ConnectedCoreConfig(Path configPath, boolean fireworkBoosting) {
        this.configPath = configPath;
        this.fireworkBoosting = fireworkBoosting;
    }

    public static ConnectedCoreConfig inMemory() {
        return new ConnectedCoreConfig(null, false);
    }

    public static ConnectedCoreConfig load(Path configDirectory) {
        Path resolvedPath = configDirectory.resolve(FILE_NAME);
        try {
            Files.createDirectories(configDirectory, new FileAttribute[0]);
        }
        catch (IOException exception) {
            LOGGER.warn("Unable to create config directory {}. Falling back to in-memory defaults.", (Object)configDirectory, (Object)exception);
            return ConnectedCoreConfig.inMemory();
        }
        boolean fireworkBoosting = false;
        if (Files.exists(resolvedPath, new LinkOption[0])) {
            Properties properties = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(resolvedPath);){
                properties.load(reader);
                String value = properties.getProperty(FIREWORK_KEY);
                if (value != null) {
                    fireworkBoosting = Boolean.parseBoolean(value);
                }
            }
            catch (IOException exception) {
                LOGGER.warn("Failed to read config {}. Rewriting defaults.", (Object)resolvedPath, (Object)exception);
            }
        } else {
            LOGGER.info("Creating default Connected Core config at {}", (Object)resolvedPath);
        }
        ConnectedCoreConfig config = new ConnectedCoreConfig(resolvedPath, fireworkBoosting);
        config.save();
        LOGGER.info("Loaded Connected Core config from {}", (Object)resolvedPath);
        return config;
    }

    public boolean isFireworkBoostingEnabled() {
        return this.fireworkBoosting;
    }

    public boolean updateFireworkBoosting(boolean enabled) {
        if (this.fireworkBoosting == enabled) {
            return false;
        }
        this.fireworkBoosting = enabled;
        this.save();
        return true;
    }

    public void save() {
        if (this.configPath == null) {
            LOGGER.warn("Skipping config save because no file path is available.");
            return;
        }
        Properties properties = new Properties();
        properties.setProperty(FIREWORK_KEY, ConnectedCoreConfig.enabledToString(this.fireworkBoosting));
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                properties.store(writer, "Connected Core configuration");
            }
        }
        catch (IOException exception) {
            LOGGER.warn("Failed to write config file {}.", (Object)this.configPath, (Object)exception);
        }
    }

    private static String enabledToString(boolean enabled) {
        return enabled ? "True" : "False";
    }
}

