/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.Commands;

import fr.madu59.Utils.CommandUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1944;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4205;
import net.minecraft.class_4207;
import net.minecraft.class_4304;
import net.minecraft.class_4703;
import net.minecraft.class_5739;
import net.minecraft.class_8520;
import net.minecraft.class_8560;
import net.minecraft.class_862;
import net.minecraft.class_863;
import net.minecraft.class_865;
import net.minecraft.class_866;
import net.minecraft.class_867;
import net.minecraft.class_868;
import net.minecraft.class_871;
import net.minecraft.class_872;
import net.minecraft.class_873;

@Environment(value=EnvType.CLIENT)
public class DebugRendererCommand {
    private static final Map<String, class_863.class_864> rendererNames = new HashMap<String, class_863.class_864>();
    private static final Map<String, Boolean> rendererStatus = new HashMap<String, Boolean>();

    public static void addRenderer(class_863.class_864 renderer, String name) {
        rendererNames.put(name, renderer);
        rendererStatus.put(name, false);
    }

    public static void register() {
        DebugRendererCommand.CreateRenderers();
        List<String> options = rendererNames.keySet().stream().toList();
        CommandUtils.registerOneArg("toggle debugrenderer", options, DebugRendererCommand::ToggleRenderer);
    }

    public static void ToggleRenderer(String name) {
        Boolean status = rendererStatus.get(name);
        if (status == null) {
            CommandUtils.feedbackMessage((class_2561)class_2561.method_43471((String)"invalid-argument"));
            return;
        }
        rendererStatus.put(name, status == false);
        CommandUtils.feedbackMessage((class_2561)class_2561.method_43470((String)("Debug Renderer '" + name + "' " + (status == false ? class_1074.method_4662((String)"enabled", (Object[])new Object[0]) : class_1074.method_4662((String)"disabled", (Object[])new Object[0])))));
    }

    public static List<class_863.class_864> GetActiveRenderers() {
        ArrayList<class_863.class_864> renderers = new ArrayList<class_863.class_864>();
        for (Map.Entry<String, class_863.class_864> entry : rendererNames.entrySet()) {
            String name = entry.getKey();
            class_863.class_864 renderer = entry.getValue();
            Boolean status = rendererStatus.get(name);
            if (status == null || !status.booleanValue()) continue;
            renderers.add(renderer);
        }
        return renderers;
    }

    public static void CreateRenderers() {
        class_310 client = class_310.method_1551();
        DebugRendererCommand.addRenderer((class_863.class_864)new class_868(), "pathfinding");
        DebugRendererCommand.addRenderer((class_863.class_864)new class_872(client), "water");
        DebugRendererCommand.addRenderer((class_863.class_864)new class_867(client), "heightmap");
        DebugRendererCommand.addRenderer((class_863.class_864)new class_865(client), "collisionboxes");
        DebugRendererCommand.addRenderer((class_863.class_864)new class_873(), "worldgenattempts");
        DebugRendererCommand.addRenderer((class_863.class_864)new class_866(client), "lights");
        DebugRendererCommand.addRenderer((class_863.class_864)new class_8520(client, class_1944.field_9284), "lightsections");
        DebugRendererCommand.addRenderer((class_863.class_864)new class_4703(client), "bees");
        DebugRendererCommand.addRenderer((class_863.class_864)new class_5739(client), "gameeventlisteners");
        DebugRendererCommand.addRenderer((class_863.class_864)new class_4304(client), "raids");
        DebugRendererCommand.addRenderer((class_863.class_864)new class_4205(client), "goalselectors");
        DebugRendererCommand.addRenderer((class_863.class_864)new class_862(client), "chunkborders");
        DebugRendererCommand.addRenderer((class_863.class_864)new class_4207(client), "brains");
        DebugRendererCommand.addRenderer((class_863.class_864)new class_871(client), "solidfaces");
        DebugRendererCommand.addRenderer((class_863.class_864)new class_8560(client), "supportblocks");
    }
}

