/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.dries007.tfc.common.entities.aquatic.Fish;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.SoundType;
import net.neoforged.neoforge.common.util.DeferredSoundType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class TFCSounds {
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"tfc");
    public static final Id KNAP_STONE = TFCSounds.register("item.knapping.stone");
    public static final Id KNAP_CLAY = TFCSounds.register("item.knapping.clay");
    public static final Id KNAP_LEATHER = TFCSounds.register("item.knapping.leather");
    public static final Id FIRESTARTER = TFCSounds.register("item.firestarter.use");
    public static final Id CERAMIC_BREAK = TFCSounds.register("item.ceramic.break");
    public static final Id JUG_BLOW = TFCSounds.register("item.jug.blow");
    public static final Id PANNING = TFCSounds.register("item.pan.use");
    public static final Id FERTILIZER_USE = TFCSounds.register("item.fertilizer.use");
    public static final Id JAVELIN_HIT = TFCSounds.register("item.javelin.hit");
    public static final Id JAVELIN_HIT_GROUND = TFCSounds.register("item.javelin.hit_ground");
    public static final Id JAVELIN_THROWN = TFCSounds.register("item.javelin.throw");
    public static final Id ITEM_COOL = TFCSounds.register("item.cool");
    public static final Id QUERN_DRAG = TFCSounds.register("block.quern.drag");
    public static final Id LOOM_WEAVE = TFCSounds.register("block.loom.weave");
    public static final Id TOOL_RACK_PLACE = TFCSounds.register("block.tool_rack.place");
    public static final Id BELLOWS_BLOW = TFCSounds.register("block.bellows.blow");
    public static final Id SCRIBING_TABLE = TFCSounds.register("block.scribing_table.use");
    public static final Id OPEN_BARREL = TFCSounds.register("block.barrel.open");
    public static final Id CLOSE_BARREL = TFCSounds.register("block.barrel.close");
    public static final Id OPEN_VESSEL = TFCSounds.register("block.large_vessel.open");
    public static final Id CLOSE_VESSEL = TFCSounds.register("block.large_vessel.close");
    public static final Id WATTLE_DYED = TFCSounds.register("block.wattle.dyed");
    public static final Id WATTLE_DAUBED = TFCSounds.register("block.wattle.daubed");
    public static final Id WATTLE_WOVEN = TFCSounds.register("block.wattle.woven");
    public static final Id ANVIL_HIT = TFCSounds.register("block.anvil.hit");
    public static final Id CROP_STICK_ADD = TFCSounds.register("block.crop.stick_add");
    public static final Id BLOOMERY_CRACKLE = TFCSounds.register("block.bloomery.crackle");
    public static final Id BARREL_DRIP = TFCSounds.register("block.barrel.drip");
    public static final Id COPPER_EQUIP = TFCSounds.register("item.armor.equip_copper");
    public static final Id BISMUTH_BRONZE_EQUIP = TFCSounds.register("item.armor.equip_bismuth_bronze");
    public static final Id BLACK_BRONZE_EQUIP = TFCSounds.register("item.armor.equip_black_bronze");
    public static final Id BRONZE_EQUIP = TFCSounds.register("item.armor.equip_bronze");
    public static final Id WROUGHT_IRON_EQUIP = TFCSounds.register("item.armor.equip_wrought_iron");
    public static final Id STEEL_EQUIP = TFCSounds.register("item.armor.equip_steel");
    public static final Id BLACK_STEEL_EQUIP = TFCSounds.register("item.armor.equip_black_steel");
    public static final Id BLUE_STEEL_EQUIP = TFCSounds.register("item.armor.equip_blue_steel");
    public static final Id RED_STEEL_EQUIP = TFCSounds.register("item.armor.equip_red_steel");
    public static final SoundType CHARCOAL = TFCSounds.registerBlock("charcoal");
    public static final SoundType THATCH = TFCSounds.registerBlock("thatch");
    public static final SoundType PEAT = TFCSounds.registerBlock("peat");
    public static final SoundType THIN = TFCSounds.registerBlock("thin");
    public static final EntityId PIG = TFCSounds.registerEntity(SoundEvents.PIG_AMBIENT, SoundEvents.PIG_DEATH, SoundEvents.PIG_HURT, SoundEvents.PIG_STEP);
    public static final EntityId COW = TFCSounds.registerEntity(SoundEvents.COW_AMBIENT, SoundEvents.COW_DEATH, SoundEvents.COW_HURT, SoundEvents.COW_STEP);
    public static final EntityId CHICKEN = TFCSounds.registerEntity(SoundEvents.CHICKEN_AMBIENT, SoundEvents.CHICKEN_DEATH, SoundEvents.CHICKEN_HURT, SoundEvents.CHICKEN_STEP);
    public static final EntityId GOAT = TFCSounds.registerEntity(SoundEvents.GOAT_AMBIENT, SoundEvents.GOAT_DEATH, SoundEvents.GOAT_HURT, SoundEvents.GOAT_STEP);
    public static final EntityId SHEEP = TFCSounds.registerEntity(SoundEvents.SHEEP_AMBIENT, SoundEvents.SHEEP_DEATH, SoundEvents.SHEEP_HURT, SoundEvents.SHEEP_STEP);
    public static final EntityId DONKEY = TFCSounds.registerEntity(SoundEvents.DONKEY_AMBIENT, SoundEvents.DONKEY_DEATH, SoundEvents.DONKEY_HURT, SoundEvents.HORSE_STEP);
    public static final EntityId MULE = TFCSounds.registerEntity(SoundEvents.MULE_AMBIENT, SoundEvents.MULE_DEATH, SoundEvents.MULE_HURT, SoundEvents.HORSE_STEP);
    public static final EntityId HORSE = TFCSounds.registerEntity(SoundEvents.HORSE_AMBIENT, SoundEvents.HORSE_DEATH, SoundEvents.HORSE_HURT, SoundEvents.HORSE_STEP);
    public static final EntityId CAT = new EntityId(() -> SoundEvents.CAT_AMBIENT, () -> SoundEvents.CAT_DEATH, () -> SoundEvents.CAT_HURT, () -> SoundEvents.CHICKEN_STEP, Optional.of(() -> SoundEvents.CAT_HISS), Optional.of(() -> SoundEvents.CAT_PURR));
    public static final EntityId TURTLE = TFCSounds.registerEntity(SoundEvents.TURTLE_AMBIENT_LAND, SoundEvents.TURTLE_DEATH, SoundEvents.TURTLE_HURT, SoundEvents.TURTLE_SHAMBLE);
    public static final EntityId DOG = TFCSounds.registerEntity("dog", true, true);
    public static final EntityId TFC_WOLF = TFCSounds.registerEntity("tfc_wolf", true, true);
    public static final EntityId HYENA = TFCSounds.registerEntity("hyena", true, true);
    public static final EntityId ALPACA = TFCSounds.registerEntity("alpaca", false, false);
    public static final EntityId YAK = TFCSounds.registerEntity("yak", false, false);
    public static final EntityId MUSK_OX = TFCSounds.registerEntity("musk_ox", false, false);
    public static final EntityId DUCK = TFCSounds.registerEntity("duck", false, false);
    public static final EntityId PENGUIN = TFCSounds.registerEntity("penguin", false, false);
    public static final EntityId SEAL = TFCSounds.registerEntity("seal", true, false);
    public static final EntityId QUAIL = TFCSounds.registerEntity("quail", false, false);
    public static final EntityId LION = TFCSounds.registerEntity("lion", true, true);
    public static final EntityId COUGAR = TFCSounds.registerEntity("cougar", true, true);
    public static final EntityId SABERTOOTH = TFCSounds.registerEntity("sabertooth", true, true);
    public static final EntityId TIGER = TFCSounds.registerEntity("tiger", true, true);
    public static final EntityId CROCODILE = TFCSounds.registerEntity("crocodile", true, true);
    public static final EntityId BEAR = TFCSounds.registerEntity("bear", true, true);
    public static final EntityId DEER = TFCSounds.registerEntity("deer", false, false);
    public static final EntityId BOAR = TFCSounds.registerEntity("boar", true, false);
    public static final EntityId WILDEBEEST = TFCSounds.registerEntity("wildebeest", true, false);
    public static final EntityId BISON = TFCSounds.registerEntity("bison", true, false);
    public static final EntityId MOOSE = TFCSounds.registerEntity("moose", true, false);
    public static final EntityId GROUSE = TFCSounds.registerEntity("grouse", false, false);
    public static final EntityId PHEASANT = TFCSounds.registerEntity("pheasant", false, false);
    public static final EntityId TURKEY = TFCSounds.registerEntity("turkey", false, false);
    public static final EntityId PEAFOWL = TFCSounds.registerEntity("peafowl", false, false);
    public static final EntityId RAT = TFCSounds.registerEntity("rat", false, false);
    public static final EntityId BONGO = TFCSounds.registerEntity("bongo", false, false);
    public static final EntityId CARIBOU = TFCSounds.registerEntity("caribou", false, false);
    public static final EntityId GAZELLE = TFCSounds.registerEntity("gazelle", false, false);
    public static final FishId MANATEE = TFCSounds.registerFish("manatee");
    public static final FishId JELLYFISH = TFCSounds.registerFish("jellyfish");
    public static final Map<Fish, FishId> FRESHWATER_FISHES = Helpers.mapOf(Fish.class, Fish::makeSound);
    public static final Id ROOSTER_CRY = TFCSounds.register("entity.rooster.cry");
    public static final Id RAMMING_IMPACT = TFCSounds.register("entity.ramming.impact");
    public static final Id ROCK_SLIDE_LONG = TFCSounds.register("random.rock_slide_long");
    public static final Id ROCK_SLIDE_LONG_FAKE = TFCSounds.register("random.rock_slide_long_fake");
    public static final Id ROCK_SLIDE_SHORT = TFCSounds.register("random.rock_slide_short");
    public static final Id DIRT_SLIDE_SHORT = TFCSounds.register("random.dirt_slide_short");
    public static final Id ROCK_SMASH = TFCSounds.register("random.rock_smash");

    private static Id register(String name) {
        return new Id((DeferredHolder<SoundEvent, SoundEvent>)SOUNDS.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Helpers.identifier(name))));
    }

    private static SoundType registerBlock(String name) {
        return new DeferredSoundType(1.0f, 1.0f, (Supplier)TFCSounds.register("block.%s.break".formatted(name)), (Supplier)TFCSounds.register("block.%s.step".formatted(name)), (Supplier)TFCSounds.register("block.%s.place".formatted(name)), (Supplier)TFCSounds.register("block.%s.hit".formatted(name)), (Supplier)TFCSounds.register("block.%s.fall".formatted(name)));
    }

    private static EntityId registerEntity(SoundEvent ambient, SoundEvent death, SoundEvent hurt, SoundEvent step) {
        return new EntityId(() -> ambient, () -> death, () -> hurt, () -> step, Optional.empty(), Optional.empty());
    }

    private static EntityId registerEntity(String name, boolean attack, boolean sleep) {
        return new EntityId(TFCSounds.register("entity.%s.ambient".formatted(name)), TFCSounds.register("entity.%s.death".formatted(name)), TFCSounds.register("entity.%s.hurt".formatted(name)), TFCSounds.register("entity.%s.step".formatted(name)), attack ? Optional.of(TFCSounds.register("entity.%s.attack".formatted(name))) : Optional.empty(), sleep ? Optional.of(TFCSounds.register("entity.%s.sleep".formatted(name))) : Optional.empty());
    }

    public static FishId registerFish(String name) {
        return new FishId(TFCSounds.register("entity.%s.ambient".formatted(name)), TFCSounds.register("entity.%s.death".formatted(name)), TFCSounds.register("entity.%s.hurt".formatted(name)), TFCSounds.register("entity.%s.flop".formatted(name)));
    }

    public record Id(DeferredHolder<SoundEvent, SoundEvent> holder) implements RegistryHolder<SoundEvent, SoundEvent>
    {
    }

    public record EntityId(Supplier<SoundEvent> ambient, Supplier<SoundEvent> death, Supplier<SoundEvent> hurt, Supplier<SoundEvent> step, Optional<Supplier<SoundEvent>> attack, Optional<Supplier<SoundEvent>> sleep) {
    }

    public record FishId(Supplier<SoundEvent> ambient, Supplier<SoundEvent> death, Supplier<SoundEvent> hurt, Supplier<SoundEvent> flop) {
    }
}

