/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.SimpleStaticBlockEntityModel;
import net.dries007.tfc.common.blockentities.ScrapingBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.joml.Matrix4f;

public enum ScrapingBlockModel implements SimpleStaticBlockEntityModel<ScrapingBlockModel, ScrapingBlockEntity>
{
    INSTANCE;


    @Override
    public TextureAtlasSprite render(ScrapingBlockEntity scraping, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        if (scraping.getInputTexture() != null && scraping.getOutputTexture() != null) {
            short positions = scraping.getScrapedPositions();
            this.drawTiles(buffer, poseStack, scraping.getInputTexture(), positions, 0, packedLight, packedOverlay, scraping.getColor1());
            this.drawTiles(buffer, poseStack, scraping.getOutputTexture(), positions, 1, packedLight, packedOverlay, scraping.getColor2());
        }
        if (scraping.getOutputTexture() != null) {
            return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(RenderHelpers.BLOCKS_ATLAS).apply(scraping.getOutputTexture());
        }
        return RenderHelpers.missingTexture();
    }

    @Override
    public BlockEntityType<ScrapingBlockEntity> type() {
        return (BlockEntityType)TFCBlockEntities.SCRAPING.get();
    }

    @Override
    public int faces(ScrapingBlockEntity blockEntity) {
        return 16;
    }

    private void drawTiles(VertexConsumer buffer, PoseStack poseStack, ResourceLocation texture, short positions, int condition, int packedLight, int packedOverlay, int color) {
        Matrix4f mat = poseStack.last().pose();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(RenderHelpers.BLOCKS_ATLAS).apply(texture);
        for (int xOffset = 0; xOffset < 4; ++xOffset) {
            for (int zOffset = 0; zOffset < 4; ++zOffset) {
                if ((positions >> xOffset + 4 * zOffset & 1) != condition) continue;
                buffer.addVertex(mat, (float)xOffset / 4.0f, 0.01f, (float)zOffset / 4.0f).setColor(color).setUv(sprite.getU((float)xOffset * 4.0f / 16.0f), sprite.getV((float)zOffset * 4.0f / 16.0f)).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
                buffer.addVertex(mat, (float)xOffset / 4.0f, 0.01f, (float)zOffset / 4.0f + 0.25f).setColor(color).setUv(sprite.getU((float)xOffset * 4.0f / 16.0f), sprite.getV(((float)zOffset * 4.0f + 4.0f) / 16.0f)).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
                buffer.addVertex(mat, (float)xOffset / 4.0f + 0.25f, 0.01f, (float)zOffset / 4.0f + 0.25f).setColor(color).setUv(sprite.getU(((float)xOffset * 4.0f + 4.0f) / 16.0f), sprite.getV(((float)zOffset * 4.0f + 4.0f) / 16.0f)).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
                buffer.addVertex(mat, (float)xOffset / 4.0f + 0.25f, 0.01f, (float)zOffset / 4.0f).setColor(color).setUv(sprite.getU(((float)xOffset * 4.0f + 4.0f) / 16.0f), sprite.getV((float)zOffset * 4.0f / 16.0f)).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
            }
        }
    }
}

