/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.dries007.tfc.client.model.IBakedGeometry;
import net.dries007.tfc.client.model.IStaticBakedModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.jetbrains.annotations.NotNull;

public interface SimpleStaticBlockEntityModel<T extends IBakedGeometry<T>, B extends BlockEntity>
extends IBakedGeometry<T>,
IStaticBakedModel {
    @NotNull
    default public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null && blockEntity.getType() == this.type()) {
            return modelData.derive().with(IStaticBakedModel.StaticModelData.PROPERTY, (Object)this.render(level, pos, blockEntity)).build();
        }
        return modelData;
    }

    default public IStaticBakedModel.StaticModelData render(BlockAndTintGetter level, BlockPos pos, B blockEntity) {
        int packedLight = LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, pos), (int)level.getBrightness(LightLayer.SKY, pos));
        int packedOverlay = OverlayTexture.NO_OVERLAY;
        final ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.faces(blockEntity));
        class Baker
        extends QuadBakingVertexConsumer {
            int count = 0;

            Baker() {
            }

            public VertexConsumer addVertex(float x, float y, float z) {
                if (this.count == 4) {
                    this.count = 0;
                    quads.add(this.bakeQuad());
                }
                ++this.count;
                return super.addVertex(x, y, z);
            }
        }
        Baker baker = new Baker();
        TextureAtlasSprite particle = this.render(blockEntity, new PoseStack(), (VertexConsumer)baker, packedLight, packedOverlay);
        if (baker.count > 0) {
            quads.add(baker.bakeQuad());
        }
        return new IStaticBakedModel.StaticModelData(quads, particle);
    }

    public TextureAtlasSprite render(B var1, PoseStack var2, VertexConsumer var3, int var4, int var5);

    public BlockEntityType<B> type();

    public int faces(B var1);
}

