/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import net.dries007.tfc.client.model.entity.DeerModel;
import net.dries007.tfc.client.model.entity.HierarchicalAnimatedModel;
import net.dries007.tfc.common.entities.prey.Prey;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class BongoModel
extends HierarchicalAnimatedModel<Prey> {
    private final ModelPart head;

    public BongoModel(ModelPart root) {
        super(root);
        this.head = root.getChild("body").getChild("neck").getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -20.0f, -9.0f, 7.0f, 10.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)25.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)-14.0f, (float)-7.0f));
        PartDefinition neck0_r1 = neck.addOrReplaceChild("neck0_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5872f, -9.4021f, -1.1846f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0872f, (float)0.0038f, (float)-1.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 27).addBox(-2.5872f, -4.0038f, -4.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(8, 37).addBox(-1.5872f, -2.0038f, -7.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0872f, (float)-6.9962f, (float)-5.0f));
        PartDefinition earL = head.addOrReplaceChild("earL", CubeListBuilder.create(), PartPose.offsetAndRotation((float)2.0f, (float)-4.0f, (float)0.0f, (float)-0.0873f, (float)0.0175f, (float)0.1396f));
        PartDefinition ear_r1 = earL.addOrReplaceChild("ear_r1", CubeListBuilder.create().texOffs(37, 12).addBox(-1.0f, -1.0f, 0.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition earR = head.addOrReplaceChild("earR", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.0f, (float)-4.0f, (float)0.0f, (float)-0.0873f, (float)0.0175f, (float)-0.1396f));
        PartDefinition ear_r2 = earR.addOrReplaceChild("ear_r2", CubeListBuilder.create().texOffs(15, 27).addBox(-2.0f, -1.0f, 0.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition hornR = head.addOrReplaceChild("hornR", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.25f, (float)-4.0f, (float)-1.5f, (float)-0.7201f, (float)0.262f, (float)0.0998f));
        PartDefinition antler0_r1 = hornR.addOrReplaceChild("antler0_r1", CubeListBuilder.create().texOffs(42, 37).addBox(-1.0f, -3.5f, 0.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3155f, (float)0.1624f, (float)-0.4068f));
        PartDefinition hornR2 = hornR.addOrReplaceChild("hornR2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.0f, (float)-4.0f, (float)-1.25f, (float)0.0422f, (float)0.2137f, (float)0.845f));
        PartDefinition antler0_r2 = hornR2.addOrReplaceChild("antler0_r2", CubeListBuilder.create().texOffs(32, 42).addBox(-1.0627f, -3.7629f, 0.767f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.75f, (float)0.5f, (float)0.0f, (float)0.3701f, (float)-0.2343f, (float)-0.727f));
        PartDefinition hornL = head.addOrReplaceChild("hornL", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.0757f, (float)-4.0f, (float)-1.5f, (float)-0.7201f, (float)-0.262f, (float)-0.0998f));
        PartDefinition antler0_r3 = hornL.addOrReplaceChild("antler0_r3", CubeListBuilder.create().texOffs(28, 39).addBox(0.0f, -3.5f, 0.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3155f, (float)-0.1624f, (float)0.4068f));
        PartDefinition hornL2 = hornL.addOrReplaceChild("hornL2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)2.0f, (float)-4.0f, (float)-1.25f, (float)0.0422f, (float)-0.2137f, (float)-0.845f));
        PartDefinition antler0_r4 = hornL2.addOrReplaceChild("antler0_r4", CubeListBuilder.create().texOffs(0, 27).addBox(0.0627f, -3.7629f, 0.767f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.75f, (float)0.5f, (float)0.0f, (float)0.3701f, (float)0.2343f, (float)0.727f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(36, 38).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-19.0f, (float)7.25f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(31, 12).addBox(-0.51f, 2.8302f, -3.2139f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.25f, (float)8.5f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild("tail3", CubeListBuilder.create().texOffs(0, 12).addBox(-0.51f, -0.8217f, -3.0658f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)3.25f, (float)0.5f, (float)-2.7053f, (float)0.0f, (float)0.0f));
        PartDefinition legBR = body.addOrReplaceChild("legBR", CubeListBuilder.create().texOffs(31, 0).addBox(-1.0f, -3.0f, -2.0f, 2.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(40, 27).addBox(-1.0f, 5.0f, 0.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-14.0f, (float)5.0f));
        PartDefinition legBL = body.addOrReplaceChild("legBL", CubeListBuilder.create().texOffs(20, 27).addBox(0.0f, -3.0f, -2.0f, 2.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(20, 39).addBox(0.0f, 5.0f, 0.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-14.0f, (float)5.0f));
        PartDefinition legFR = body.addOrReplaceChild("legFR", CubeListBuilder.create().texOffs(32, 27).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 13.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-14.0f, (float)-6.0f));
        PartDefinition legFL = body.addOrReplaceChild("legFL", CubeListBuilder.create().texOffs(0, 37).addBox(0.0f, 0.0f, -1.0f, 2.0f, 13.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-14.0f, (float)-6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void setupAnim(Prey entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
        float speed = this.getAdjustedLandSpeed(entity);
        if (speed > 1.1f) {
            this.animateWalk(DeerModel.DEER_RUN, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        } else {
            this.animateWalk(DeerModel.DEER_WALK, limbSwing, limbSwingAmount, 2.5f, 2.5f);
        }
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
    }
}

