/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.dries007.tfc.common.blockentities.CalendarClockBlockEntity;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;

public class CalendarClockModel
extends Model {
    private final ModelPart static_parts;
    private final ModelPart month_hand;
    private final ModelPart hour_hand;
    private final ModelPart minute_hand;

    public CalendarClockModel(ModelPart root) {
        super(RenderType::entityCutoutNoCull);
        this.static_parts = root.getChild("static_parts");
        this.month_hand = root.getChild("month_hand");
        this.hour_hand = root.getChild("hour_hand");
        this.minute_hand = root.getChild("minute_hand");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition static_parts = partdefinition.addOrReplaceChild("static_parts", CubeListBuilder.create().texOffs(0, 15).addBox(-15.0f, -1.0f, 1.0f, 14.0f, 1.0f, 14.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-15.0f, -2.0f, 1.0f, 14.0f, 1.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)24.0f, (float)-8.0f));
        PartDefinition month_hand = partdefinition.addOrReplaceChild("month_hand", CubeListBuilder.create().texOffs(15, 30).addBox(-0.5f, -2.49f, -6.5f, 1.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)25.25f, (float)0.0f));
        PartDefinition hour_hand = partdefinition.addOrReplaceChild("hour_hand", CubeListBuilder.create().texOffs(29, 30).addBox(-0.5f, -1.51f, -4.5f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.25f, (float)0.0f));
        PartDefinition minute_hand = partdefinition.addOrReplaceChild("minute_hand", CubeListBuilder.create().texOffs(0, 30).addBox(-0.5f, -2.52f, -6.5f, 1.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)25.25f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(CalendarClockBlockEntity clock, float partialTick) {
        this.minute_hand.yRot = clock.getAngles()[0] + (float)Math.PI;
        this.hour_hand.yRot = clock.getAngles()[1] + (float)Math.PI;
        this.month_hand.yRot = clock.getAngles()[2] + (float)Math.PI;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.static_parts.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.hour_hand.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.minute_hand.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.month_hand.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

