/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.dries007.tfc.common.entities.livestock.horse.TFCChestedHorse;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class HorseChestLayer<T extends TFCChestedHorse, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final Map<Item, ResourceLocation> MAP = new HashMap<Item, ResourceLocation>();
    private static final ResourceLocation DEFAULT_CHEST_TEXTURE = Helpers.identifier("textures/entity/chest/horse/oak.png");
    private final M model;

    public static void registerChest(Item item, ResourceLocation location) {
        MAP.put(item, location);
    }

    public HorseChestLayer(RenderLayerParent<T, M> parent, M model) {
        super(parent);
        this.model = model;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float yaw, float pitch) {
        if (!((TFCChestedHorse)entity).getChestItem().isEmpty()) {
            this.getParentModel().copyPropertiesTo(this.model);
            this.model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
            this.model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, yaw, pitch);
            VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTexture(entity)));
            this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
        }
    }

    private ResourceLocation getTexture(T entity) {
        Item item = ((TFCChestedHorse)entity).getChestItem().getItem();
        if (MAP.containsKey(item)) {
            return MAP.get(item);
        }
        return DEFAULT_CHEST_TEXTURE;
    }
}

