/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.dries007.tfc.common.entities.aquatic.Jellyfish;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class JellyfishModel
extends EntityModel<Jellyfish> {
    private final ModelPart head;
    private final ModelPart tail1;
    private final ModelPart tail2;
    private final ModelPart tail3;
    private final ModelPart tail4;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(12, 7).addBox(-1.0f, 3.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-3.0f, 2.0f, -3.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 7).addBox(-2.0f, 1.0f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition tail1 = partdefinition.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(0, 12).addBox(-0.6476f, 2.1436f, -0.6413f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)15.0f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)0.0873f));
        PartDefinition tail2 = partdefinition.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(4, 12).addBox(-0.2615f, 0.9772f, 0.2605f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)16.0f, (float)-2.0f, (float)-0.0873f, (float)0.0f, (float)-0.0873f));
        PartDefinition tail3 = partdefinition.addOrReplaceChild("tail3", CubeListBuilder.create().texOffs(8, 12).addBox(-0.2615f, 0.9772f, -0.2605f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)16.0f, (float)1.0f, (float)0.0873f, (float)0.0f, (float)-0.0873f));
        PartDefinition tail4 = partdefinition.addOrReplaceChild("tail4", CubeListBuilder.create().texOffs(12, 12).addBox(0.2615f, 0.9772f, -0.2605f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)16.0f, (float)1.0f, (float)0.0873f, (float)0.0f, (float)0.0873f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public JellyfishModel(ModelPart root) {
        this.head = root.getChild("head");
        this.tail1 = root.getChild("tail1");
        this.tail2 = root.getChild("tail2");
        this.tail3 = root.getChild("tail3");
        this.tail4 = root.getChild("tail4");
    }

    public void setupAnim(Jellyfish entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float oscillation = -0.2f * Mth.sin((float)(0.06f * ageInTicks));
        this.tail1.xRot = -1.0f * oscillation;
        this.tail1.zRot = oscillation;
        this.tail2.xRot = -1.0f * oscillation;
        this.tail2.zRot = -1.0f * oscillation;
        this.tail3.xRot = oscillation;
        this.tail3.zRot = -1.0f * oscillation;
        this.tail4.xRot = oscillation;
        this.tail4.zRot = oscillation;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, buffer, packedLight, packedOverlay);
        this.tail1.render(poseStack, buffer, packedLight, packedOverlay);
        this.tail2.render(poseStack, buffer, packedLight, packedOverlay);
        this.tail3.render(poseStack, buffer, packedLight, packedOverlay);
        this.tail4.render(poseStack, buffer, packedLight, packedOverlay);
    }
}

