/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import java.util.stream.Stream;
import net.dries007.tfc.client.model.entity.HierarchicalAnimatedModel;
import net.dries007.tfc.common.entities.prey.RammingPrey;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MooseModel
extends HierarchicalAnimatedModel<RammingPrey> {
    public static final AnimationDefinition MOOSE_RUN = AnimationDefinition.Builder.withLength((float)0.9583434f).looping().addAnimation("neck", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)-4.5661516f, (float)5.398936f, (float)4.5661516f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.89099824f, (float)2.4405522f, (float)1.5636137f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, KeyframeAnimations.degreeVec((float)-3.6843684f, (float)-4.6235404f, (float)-5.3985906f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.9583434f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("left_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)-12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.7083434f, KeyframeAnimations.degreeVec((float)17.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.9583434f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("left_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.7083434f, KeyframeAnimations.degreeVec((float)-12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.9583434f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("right_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)-12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.7083434f, KeyframeAnimations.degreeVec((float)15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.9583434f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("right_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)20.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.7083434f, KeyframeAnimations.degreeVec((float)-10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.9583434f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).build();
    public static final AnimationDefinition MOOSE_EAT_GRASS = AnimationDefinition.Builder.withLength((float)12.291676f).addAnimation("moose", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("body", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(2.125f, KeyframeAnimations.degreeVec((float)-17.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(11.041676f, KeyframeAnimations.degreeVec((float)-17.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(12.291676f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("neck", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(2.125f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(11.791676f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(12.291676f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("neck", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(2.125f, KeyframeAnimations.degreeVec((float)-31.97f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(11.791676f, KeyframeAnimations.degreeVec((float)-31.97f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(12.291676f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("head", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(3.7916765f, KeyframeAnimations.degreeVec((float)12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(4.5f, KeyframeAnimations.degreeVec((float)2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(5.291677f, KeyframeAnimations.degreeVec((float)10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(6.583433f, KeyframeAnimations.degreeVec((float)2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(7.834333f, KeyframeAnimations.degreeVec((float)12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(9.541676f, KeyframeAnimations.degreeVec((float)20.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(11.25f, KeyframeAnimations.degreeVec((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("bone3", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(2.125f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)2.5f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("bone4", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(2.125f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-2.5f), AnimationChannel.Interpolations.LINEAR)})).build();
    public static final AnimationDefinition MOOSE_WALK = AnimationDefinition.Builder.withLength((float)1.5834333f).looping().addAnimation("neck", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.375f, KeyframeAnimations.degreeVec((float)-4.5661516f, (float)5.398936f, (float)4.5661516f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.8343334f, KeyframeAnimations.degreeVec((float)2.8063273f, (float)0.27423415f, (float)-0.57548606f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.2083433f, KeyframeAnimations.degreeVec((float)-4.680253f, (float)-4.254786f, (float)-4.722189f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.5834333f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("left_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.4167667f, KeyframeAnimations.degreeVec((float)-12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.2083433f, KeyframeAnimations.degreeVec((float)17.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.5834333f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("left_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.4167667f, KeyframeAnimations.degreeVec((float)12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.2083433f, KeyframeAnimations.degreeVec((float)-12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.5834333f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("right_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.4167667f, KeyframeAnimations.degreeVec((float)-12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.2083433f, KeyframeAnimations.degreeVec((float)15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.5834333f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("right_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.4167667f, KeyframeAnimations.degreeVec((float)20.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.2083433f, KeyframeAnimations.degreeVec((float)-10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.5834333f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).build();
    private final ModelPart moose;
    private final ModelPart neck;
    private final ModelPart antler1;
    private final ModelPart antler2;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart head;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition moose = partdefinition.addOrReplaceChild("moose", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)41.0f, (float)23.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition body = moose.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -5.04f, -0.168f, 14.0f, 17.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-48.0f, (float)-2.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(50, 43).addBox(-1.0f, -38.4515f, -5.4433f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)35.0f, (float)-9.0f, (float)-0.3578f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 43).addBox(-8.0f, -54.0f, 1.0f, 16.0f, 21.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)46.0f, (float)26.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(62, 25).addBox(-3.5f, 1.7643f, 0.1755f, 6.0f, 10.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-9.7643f, (float)31.8245f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(67, 86).addBox(0.0074f, 2.923f, -8.4288f, 0.0f, 9.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0074f, (float)6.5199f, (float)17.5063f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(6, 82).addBox(-1.6981f, -2.2641f, -5.9761f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8876f, (float)-5.2647f, (float)4.9703f, (float)-0.0763f, (float)-0.0886f, (float)-0.2467f));
        PartDefinition cube_r4 = head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(16, 12).addBox(-2.3019f, -2.3506f, -5.9845f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.8683f, (float)-5.0215f, (float)4.8818f, (float)-0.0326f, (float)0.0886f, (float)0.2467f));
        PartDefinition cube_r5 = head.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(83, 0).addBox(-3.0f, -57.0f, 50.0f, 6.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(92, 16).addBox(-4.0f, -60.0f, 41.0f, 8.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4926f, (float)35.923f, (float)-60.4288f, (float)-0.3578f, (float)0.0f, (float)0.0f));
        PartDefinition left_antler = head.addOrReplaceChild("left_antler", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-13.9398f, (float)-8.9723f, (float)4.6713f, (float)0.4349f, (float)0.0368f, (float)-0.0791f));
        PartDefinition cube_r6 = left_antler.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(54, 12).addBox(4.9564f, 5.3252f, -1.6931f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(92, 35).addBox(0.9564f, 1.3252f, -1.6931f, 8.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8055f, (float)1.0429f, (float)1.1749f, (float)0.0627f, (float)0.6157f, (float)-0.5853f));
        PartDefinition cube_r7 = left_antler.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(68, 60).addBox(-6.7375f, -2.0783f, 1.4421f, 12.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.9419f, (float)8.7268f, (float)7.112f, (float)-2.9171f, (float)1.465f, (float)2.041f));
        PartDefinition cube_r8 = left_antler.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(50, 53).addBox(-2.6847f, 1.3137f, -3.7996f, 10.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.4218f, (float)5.1432f, (float)1.1283f, (float)-0.8226f, (float)0.1677f, (float)0.0781f));
        PartDefinition cube_r9 = left_antler.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(54, 9).addBox(-4.037f, -0.6194f, -0.4597f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.6471f, (float)5.1476f, (float)-0.4881f, (float)-0.6757f, (float)1.1065f, (float)-1.9179f));
        PartDefinition cube_r10 = left_antler.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(58, 43).addBox(-0.0436f, -5.6221f, -1.7214f, 1.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8055f, (float)1.0429f, (float)1.1749f, (float)0.0191f, (float)0.6157f, (float)-0.5853f));
        PartDefinition cube_r11 = left_antler.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(0, 82).addBox(1.9564f, -10.5683f, -1.7474f, 2.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8055f, (float)1.0429f, (float)1.1749f, (float)-0.0245f, (float)0.6157f, (float)-0.5853f));
        PartDefinition cube_r12 = left_antler.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(6, 89).addBox(0.1075f, -4.8409f, -1.9375f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0766f, (float)-6.9028f, (float)-3.0826f, (float)0.0626f, (float)0.5558f, (float)-0.1181f));
        PartDefinition cube_r13 = left_antler.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(80, 63).addBox(0.1075f, -2.463f, -1.8588f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5834f, (float)-6.7346f, (float)-4.5476f, (float)0.1499f, (float)0.5558f, (float)-0.1181f));
        PartDefinition cube_r14 = left_antler.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(31, 82).addBox(0.1075f, -6.463f, -1.8588f, 2.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.4781f, (float)-6.1341f, (float)-1.3821f, (float)0.1499f, (float)0.5558f, (float)-0.1181f));
        PartDefinition cube_r15 = left_antler.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(0, 52).addBox(3.1075f, -10.1321f, 0.7786f, 8.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.4725f, (float)4.8411f, (float)0.632f, (float)0.2808f, (float)0.5558f, (float)-0.1181f));
        PartDefinition bone = left_antler.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.9419f, (float)5.7268f, (float)7.112f, (float)0.2618f, (float)-0.3491f, (float)0.0f));
        PartDefinition cube_r16 = bone.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(76, 56).addBox(-4.0915f, -2.8079f, 1.6677f, 9.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)-2.9171f, (float)1.465f, (float)2.041f));
        PartDefinition cube_r17 = bone.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(54, 6).addBox(-4.0686f, -1.4158f, -0.189f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.2949f, (float)-2.5792f, (float)-7.6002f, (float)-0.6757f, (float)1.1065f, (float)-1.9179f));
        PartDefinition right_antler = head.addOrReplaceChild("right_antler", CubeListBuilder.create(), PartPose.offsetAndRotation((float)16.6547f, (float)-8.2266f, (float)6.3154f, (float)0.4349f, (float)-0.0368f, (float)0.0791f));
        PartDefinition cube_r18 = right_antler.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(16, 19).addBox(-7.9564f, 5.3252f, -1.6931f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(50, 90).addBox(-8.9564f, 1.3252f, -1.6931f, 8.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0627f, (float)-0.6157f, (float)0.5853f));
        PartDefinition cube_r19 = right_antler.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(50, 57).addBox(-5.2625f, -2.0783f, 1.4421f, 12.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.7474f, (float)7.6839f, (float)5.9371f, (float)-2.9171f, (float)-1.465f, (float)-2.041f));
        PartDefinition cube_r20 = right_antler.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(0, 22).addBox(-7.3153f, 1.3137f, -3.7996f, 10.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.2273f, (float)4.1003f, (float)-0.0466f, (float)-0.8226f, (float)-0.1677f, (float)-0.0781f));
        PartDefinition cube_r21 = right_antler.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(54, 3).addBox(-2.963f, -0.6194f, -0.4597f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.4526f, (float)4.1047f, (float)-1.663f, (float)-0.6757f, (float)-1.1065f, (float)1.9179f));
        PartDefinition cube_r22 = right_antler.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(22, 0).addBox(-0.9564f, -5.6221f, -1.7214f, 1.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0191f, (float)-0.6157f, (float)0.5853f));
        PartDefinition cube_r23 = right_antler.addOrReplaceChild("cube_r23", CubeListBuilder.create().texOffs(16, 0).addBox(-3.9564f, -10.5683f, -1.7474f, 2.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0245f, (float)-0.6157f, (float)0.5853f));
        PartDefinition cube_r24 = right_antler.addOrReplaceChild("cube_r24", CubeListBuilder.create().texOffs(83, 0).addBox(-2.1075f, -4.8409f, -1.9375f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.7289f, (float)-7.9457f, (float)-4.2575f, (float)0.0626f, (float)-0.5558f, (float)0.1181f));
        PartDefinition cube_r25 = right_antler.addOrReplaceChild("cube_r25", CubeListBuilder.create().texOffs(62, 12).addBox(-2.1075f, -2.463f, -1.8588f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.3889f, (float)-7.7776f, (float)-5.7225f, (float)0.1499f, (float)-0.5558f, (float)0.1181f));
        PartDefinition cube_r26 = right_antler.addOrReplaceChild("cube_r26", CubeListBuilder.create().texOffs(25, 82).addBox(-2.1075f, -6.463f, -1.8588f, 2.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.6726f, (float)-7.177f, (float)-2.557f, (float)0.1499f, (float)-0.5558f, (float)0.1181f));
        PartDefinition cube_r27 = right_antler.addOrReplaceChild("cube_r27", CubeListBuilder.create().texOffs(0, 43).addBox(-11.1075f, -10.1321f, 0.7786f, 8.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.667f, (float)3.7982f, (float)-0.5429f, (float)0.2808f, (float)-0.5558f, (float)0.1181f));
        PartDefinition bone2 = right_antler.addOrReplaceChild("bone2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-4.7474f, (float)4.6839f, (float)5.9371f, (float)0.2618f, (float)0.3491f, (float)0.0f));
        PartDefinition cube_r28 = bone2.addOrReplaceChild("cube_r28", CubeListBuilder.create().texOffs(73, 53).addBox(-4.9085f, -2.8079f, 1.6677f, 9.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)-2.9171f, (float)-1.465f, (float)-2.041f));
        PartDefinition cube_r29 = bone2.addOrReplaceChild("cube_r29", CubeListBuilder.create().texOffs(54, 0).addBox(-2.9314f, -1.4158f, -0.189f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2949f, (float)-2.5792f, (float)-7.6002f, (float)-0.6757f, (float)-1.1065f, (float)1.9179f));
        PartDefinition left_hind_leg = moose.addOrReplaceChild("left_hind_leg", CubeListBuilder.create(), PartPose.offset((float)-7.0f, (float)-38.9634f, (float)-2.1665f));
        PartDefinition cube_r30 = left_hind_leg.addOrReplaceChild("cube_r30", CubeListBuilder.create().texOffs(0, 103).addBox(-8.0f, -39.0f, -21.5f, 4.0f, 18.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)42.9634f, (float)26.1665f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r31 = left_hind_leg.addOrReplaceChild("cube_r31", CubeListBuilder.create().texOffs(81, 78).addBox(-9.0f, -8.9699f, -10.5488f, 6.0f, 9.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)-1.0366f, (float)2.1665f, (float)-1.8326f, (float)0.0f, (float)0.0f));
        PartDefinition left_front_leg = moose.addOrReplaceChild("left_front_leg", CubeListBuilder.create(), PartPose.offset((float)-6.0f, (float)-42.9128f, (float)30.7086f));
        PartDefinition bone3 = left_front_leg.addOrReplaceChild("bone3", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)-2.0872f, (float)-0.7086f));
        PartDefinition cube_r32 = bone3.addOrReplaceChild("cube_r32", CubeListBuilder.create().texOffs(51, 65).addBox(-9.0f, 19.0f, -55.0f, 6.0f, 8.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.0f, (float)49.0f, (float)26.0f, (float)-1.5272f, (float)0.0f, (float)0.0f));
        PartDefinition bone5 = left_front_leg.addOrReplaceChild("bone5", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)46.9128f, (float)28.2914f));
        PartDefinition cube_r33 = bone5.addOrReplaceChild("cube_r33", CubeListBuilder.create().texOffs(25, 86).addBox(-8.0f, 25.0f, -38.0f, 4.0f, 4.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition right_front_leg = moose.addOrReplaceChild("right_front_leg", CubeListBuilder.create(), PartPose.offset((float)7.0f, (float)-42.9128f, (float)30.7086f));
        PartDefinition bone4 = right_front_leg.addOrReplaceChild("bone4", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)-2.0872f, (float)-0.7086f));
        PartDefinition cube_r34 = bone4.addOrReplaceChild("cube_r34", CubeListBuilder.create().texOffs(54, 0).addBox(-10.0f, 19.0f, -55.0f, 6.0f, 8.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)49.0f, (float)26.0f, (float)-1.5272f, (float)0.0f, (float)0.0f));
        PartDefinition bone6 = right_front_leg.addOrReplaceChild("bone6", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)34.9128f, (float)0.2914f));
        PartDefinition cube_r35 = bone6.addOrReplaceChild("cube_r35", CubeListBuilder.create().texOffs(0, 82).addBox(4.0f, 25.0f, -38.0f, 4.0f, 4.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)12.0f, (float)28.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition right_hind_leg = moose.addOrReplaceChild("right_hind_leg", CubeListBuilder.create(), PartPose.offset((float)7.0f, (float)-38.9634f, (float)-2.1665f));
        PartDefinition cube_r36 = right_hind_leg.addOrReplaceChild("cube_r36", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -39.0f, -21.5f, 4.0f, 18.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)42.9634f, (float)26.1665f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r37 = right_hind_leg.addOrReplaceChild("cube_r37", CubeListBuilder.create().texOffs(80, 53).addBox(4.0f, -8.9699f, -10.5488f, 6.0f, 9.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.0f, (float)-1.0366f, (float)2.1665f, (float)-1.8326f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public MooseModel(ModelPart root) {
        super(root);
        this.moose = root.getChild("moose");
        this.neck = this.moose.getChild("body").getChild("neck");
        this.head = this.neck.getChild("head");
        this.antler1 = this.head.getChild("left_antler");
        this.antler2 = this.head.getChild("right_antler");
        this.rightHindLeg = this.moose.getChild("right_hind_leg");
        this.leftHindLeg = this.moose.getChild("left_hind_leg");
        this.rightFrontLeg = this.moose.getChild("right_front_leg");
        this.leftFrontLeg = this.moose.getChild("left_front_leg");
    }

    @Override
    public void setupAnim(RammingPrey entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
        boolean antlers = entity.displayMaleCharacteristics();
        Stream.concat(this.antler1.getAllParts(), this.antler2.getAllParts()).forEach(p -> {
            p.visible = antlers;
        });
        float speed = this.getAdjustedLandSpeed(entity);
        if (speed > 1.0f) {
            this.animateWalk(MOOSE_RUN, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        } else {
            this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        if (entity.isTelegraphingAttack()) {
            this.head.xRot = (float)entity.getTelegraphAttackTick() * ((float)Math.PI / 180) * -1.0f;
            this.neck.xRot = (float)entity.getTelegraphAttackTick() * ((float)Math.PI / 180) * -1.0f;
        } else {
            this.head.xRot = headPitch * ((float)Math.PI / 180) * 0.6f;
            this.neck.xRot = headPitch * ((float)Math.PI / 180) * 0.4f;
            this.head.yRot = headYaw * ((float)Math.PI / 180) * 0.6f;
            this.neck.yRot = headYaw * ((float)Math.PI / 180) * 0.4f;
        }
    }
}

