/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.overworld;

import com.machinezoo.noexception.throwing.ThrowingSupplier;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.client.overworld.ClientSolarCalculatorBridge;
import net.dries007.tfc.client.overworld.SkyPos;
import net.dries007.tfc.client.overworld.Star;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.IBlockRain;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.CharcoalForgeBlock;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.tracker.WeatherHelpers;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LevelRendererExtension
extends DimensionSpecialEffects.OverworldEffects {
    public static final LevelRendererExtension INSTANCE = new LevelRendererExtension();
    private static final ResourceLocation[] RAIN_LOCATIONS = new ResourceLocation[]{Helpers.identifier("textures/environment/rain_0.png"), Helpers.identifier("textures/environment/rain_1.png"), Helpers.identifier("textures/environment/rain_2.png"), Helpers.identifier("textures/environment/rain_3.png")};
    private static final ResourceLocation[] SNOW_LOCATIONS = new ResourceLocation[]{Helpers.identifier("textures/environment/snow_0.png"), Helpers.identifier("textures/environment/snow_1.png"), Helpers.identifier("textures/environment/snow_2.png"), Helpers.identifier("textures/environment/snow_3.png")};
    private static final ResourceLocation MOON_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/sun.png");
    private static final float RAIN_MAX_ANGLE = 0.34906584f;
    private static final float SNOW_MAX_ANGLE = 0.5235988f;
    private final float[] rainSizeX;
    private final float[] rainSizeZ;
    private int rainSoundTime;
    @Nullable
    private VertexBuffer starBuffer = null;
    private final VertexBuffer skyBuffer;
    private final VertexBuffer darkBuffer;

    private static VertexBuffer createBuffer(ThrowingSupplier<?> draw) {
        VertexBuffer buffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        buffer.bind();
        buffer.upload((MeshData)Helpers.uncheck(draw));
        VertexBuffer.unbind();
        return buffer;
    }

    private LevelRendererExtension() {
        Field rainSizeX = (Field)Helpers.uncheck(() -> LevelRenderer.class.getDeclaredField("rainSizeX"));
        Field rainSizeZ = (Field)Helpers.uncheck(() -> LevelRenderer.class.getDeclaredField("rainSizeZ"));
        Method buildSkyDisc = (Method)Helpers.uncheck(() -> LevelRenderer.class.getDeclaredMethod("buildSkyDisc", Tesselator.class, Float.TYPE));
        rainSizeX.setAccessible(true);
        rainSizeZ.setAccessible(true);
        buildSkyDisc.setAccessible(true);
        LevelRenderer instance = Minecraft.getInstance().levelRenderer;
        this.rainSizeX = (float[])Helpers.uncheck(() -> rainSizeX.get(instance));
        this.rainSizeZ = (float[])Helpers.uncheck(() -> rainSizeZ.get(instance));
        this.skyBuffer = LevelRendererExtension.createBuffer(() -> buildSkyDisc.invoke(null, Tesselator.getInstance(), Float.valueOf(16.0f)));
        this.darkBuffer = LevelRendererExtension.createBuffer(() -> buildSkyDisc.invoke(null, Tesselator.getInstance(), Float.valueOf(-16.0f)));
    }

    public void updateStars(List<Star> stars) {
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.starBuffer.bind();
        this.starBuffer.upload(this.drawStars(stars));
        VertexBuffer.unbind();
    }

    private MeshData drawStars(List<Star> stars) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RandomSource random = RandomSource.create((long)42L);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        for (Star star : stars) {
            this.drawStar(buffer, star, random);
        }
        return buffer.buildOrThrow();
    }

    private void drawStar(BufferBuilder buffer, Star star, RandomSource random) {
        float zenith = star.zenith();
        float azimuth = star.azimuth();
        int color = 0xFF000000 | star.color();
        float size = Mth.clampedMap((float)star.apparentMagnitude(), (float)-1.0f, (float)6.0f, (float)0.4f, (float)0.1f);
        float sinZenith = Mth.sin((float)zenith);
        float x = 100.0f * sinZenith * Mth.cos((float)azimuth);
        float z = 100.0f * sinZenith * Mth.sin((float)azimuth);
        float y = 100.0f * Mth.cos((float)zenith);
        Vector3f pos = new Vector3f(x, y, z);
        Quaternionf q = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f), (Vector3fc)pos).rotateZ(random.nextFloat() * ((float)Math.PI * 2));
        buffer.addVertex(pos.add((Vector3fc)new Vector3f(size, -size, 0.0f).rotate((Quaternionfc)q))).setColor(color);
        buffer.addVertex(pos.add((Vector3fc)new Vector3f(size, size, 0.0f).rotate((Quaternionfc)q))).setColor(color);
        buffer.addVertex(pos.add((Vector3fc)new Vector3f(-size, size, 0.0f).rotate((Quaternionfc)q))).setColor(color);
        buffer.addVertex(pos.add((Vector3fc)new Vector3f(-size, -size, 0.0f).rotate((Quaternionfc)q))).setColor(color);
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, Matrix4f frustumMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable skyFogSetup) {
        FogType fogType;
        skyFogSetup.run();
        if (!isFoggy && (fogType = camera.getFluidInCamera()) != FogType.POWDER_SNOW && fogType != FogType.LAVA && !this.doesMobEffectBlockSky(camera)) {
            PoseStack stack = new PoseStack();
            Vec3 skyColor = level.getSkyColor(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition(), partialTick);
            SkyPos sunPos = ClientSolarCalculatorBridge.getSunPosition((Level)level, camera.getBlockPosition());
            stack.mulPose(frustumMatrix);
            FogRenderer.levelFogColor();
            Tesselator tesselator = Tesselator.getInstance();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)((float)skyColor.x), (float)((float)skyColor.y), (float)((float)skyColor.z), (float)1.0f);
            ShaderInstance shader = RenderSystem.getShader();
            assert (shader != null);
            this.skyBuffer.bind();
            this.skyBuffer.drawWithShader(stack.last().pose(), projectionMatrix, shader);
            VertexBuffer.unbind();
            RenderSystem.enableBlend();
            float[] sunriseColor = level.effects().getSunriseColor(level.getTimeOfDay(partialTick), partialTick);
            if (sunriseColor != null) {
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Matrix4f pose = this.rotateTo(stack, SkyPos.of(-1.5707963705062866, sunPos.azimuth() + (float)Math.PI));
                BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                buffer.addVertex(pose, 0.0f, 100.0f, 0.0f).setColor(sunriseColor[0], sunriseColor[1], sunriseColor[2], sunriseColor[3]);
                for (int i = 0; i <= 16; ++i) {
                    float angle = (float)i * ((float)Math.PI * 2) / 16.0f;
                    float sin = Mth.sin((float)angle);
                    float cos = Mth.cos((float)angle);
                    buffer.addVertex(pose, sin * 120.0f, cos * 120.0f, -cos * 40.0f * sunriseColor[3]).setColor(sunriseColor[0], sunriseColor[1], sunriseColor[2], 0.0f);
                }
                BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            }
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            float rainAlpha = 1.0f - level.getRainLevel(partialTick);
            float starAlpha = level.getStarBrightness(partialTick);
            float nightAlpha = starAlpha * rainAlpha;
            if (nightAlpha > 0.0f && this.starBuffer != null) {
                SkyPos starPos = ClientSolarCalculatorBridge.getStarPosition((Level)level, camera.getBlockPosition());
                RenderSystem.setShaderColor((float)nightAlpha, (float)nightAlpha, (float)nightAlpha, (float)nightAlpha);
                FogRenderer.setupNoFog();
                Matrix4f stars = this.rotateSkyTo(stack, starPos);
                ShaderInstance starShader = GameRenderer.getPositionColorShader();
                assert (starShader != null);
                this.starBuffer.bind();
                this.starBuffer.drawWithShader(stars, projectionMatrix, starShader);
                VertexBuffer.unbind();
                skyFogSetup.run();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            double distanceAboveHorizon = camera.getEntity().getEyePosition((float)partialTick).y - level.getLevelData().getHorizonHeight((LevelHeightAccessor)level);
            if (distanceAboveHorizon < 0.0) {
                stack.pushPose();
                stack.translate(0.0f, 12.0f, 0.0f);
                this.darkBuffer.bind();
                this.darkBuffer.drawWithShader(stack.last().pose(), projectionMatrix, shader);
                VertexBuffer.unbind();
                stack.popPose();
            }
            Matrix4f sun = this.rotateTo(stack, sunPos);
            SkyPos moonPos = ClientSolarCalculatorBridge.getMoonPosition((Level)level, camera.getBlockPosition());
            Matrix4f moon = this.rotateTo(stack, moonPos);
            float[] coverColors = sunriseColor != null ? Arrays.copyOf(sunriseColor, sunriseColor.length) : new float[]{(float)skyColor.x, (float)skyColor.y, (float)skyColor.z};
            coverColors[0] = (float)skyColor.x;
            coverColors[1] = (float)skyColor.y;
            coverColors[2] = (float)skyColor.z;
            FogRenderer.levelFogColor();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            buffer.addVertex(sun, -7.5f, 100.0f, -7.5f).setColor(coverColors[0], coverColors[1], coverColors[2], 1.0f);
            buffer.addVertex(sun, 7.5f, 100.0f, -7.5f).setColor(coverColors[0], coverColors[1], coverColors[2], 1.0f);
            buffer.addVertex(sun, 7.5f, 100.0f, 7.5f).setColor(coverColors[0], coverColors[1], coverColors[2], 1.0f);
            buffer.addVertex(sun, -7.5f, 100.0f, 7.5f).setColor(coverColors[0], coverColors[1], coverColors[2], 1.0f);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            buffer.addVertex(moon, -7.5f, 100.0f, -7.5f).setColor(coverColors[0], coverColors[1], coverColors[2], 1.0f);
            buffer.addVertex(moon, 7.5f, 100.0f, -7.5f).setColor(coverColors[0], coverColors[1], coverColors[2], 1.0f);
            buffer.addVertex(moon, 7.5f, 100.0f, 7.5f).setColor(coverColors[0], coverColors[1], coverColors[2], 1.0f);
            buffer.addVertex(moon, -7.5f, 100.0f, 7.5f).setColor(coverColors[0], coverColors[1], coverColors[2], 1.0f);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)rainAlpha);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_LOCATION);
            buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            buffer.addVertex(sun, -30.0f, 100.0f, -30.0f).setUv(0.0f, 0.0f);
            buffer.addVertex(sun, 30.0f, 100.0f, -30.0f).setUv(1.0f, 0.0f);
            buffer.addVertex(sun, 30.0f, 100.0f, 30.0f).setUv(1.0f, 1.0f);
            buffer.addVertex(sun, -30.0f, 100.0f, 30.0f).setUv(0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            float moonAlpha = (0.2f + 0.8f * starAlpha) * rainAlpha;
            int moonPhase = ClientSolarCalculatorBridge.getMoonPhase();
            int moonU = moonPhase % 4;
            int moonV = moonPhase / 4 % 2;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)moonAlpha);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_LOCATION);
            buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            buffer.addVertex(moon, -30.0f, 100.0f, -30.0f).setUv((float)moonU / 4.0f, (float)(moonV + 1) / 2.0f);
            buffer.addVertex(moon, 30.0f, 100.0f, -30.0f).setUv((float)(moonU + 1) / 4.0f, (float)(moonV + 1) / 2.0f);
            buffer.addVertex(moon, 30.0f, 100.0f, 30.0f).setUv((float)(moonU + 1) / 4.0f, (float)moonV / 2.0f);
            buffer.addVertex(moon, -30.0f, 100.0f, 30.0f).setUv((float)moonU / 4.0f, (float)moonV / 2.0f);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }

    private Matrix4f rotateTo(PoseStack stack, SkyPos pos) {
        stack.pushPose();
        stack.mulPose(Axis.YP.rotation(pos.azimuth()));
        stack.mulPose(Axis.XN.rotation(pos.zenith()));
        Matrix4f pose = new Matrix4f((Matrix4fc)stack.last().pose());
        stack.popPose();
        return pose;
    }

    private Matrix4f rotateSkyTo(PoseStack stack, SkyPos pos) {
        stack.pushPose();
        stack.mulPose(Axis.XN.rotation(pos.zenith()));
        stack.mulPose(Axis.YN.rotation(pos.azimuth()));
        Matrix4f pose = new Matrix4f((Matrix4fc)stack.last().pose());
        stack.popPose();
        return pose;
    }

    public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double sourceCameraX, double sourceCameraY, double sourceCameraZ) {
        float rainLevel = ClimateRenderCache.INSTANCE.getRainLevel(partialTick);
        if (rainLevel > 0.0f) {
            lightTexture.turnOnLightLayer();
            float camX = (float)sourceCameraX;
            float camY = (float)sourceCameraY;
            float camZ = (float)sourceCameraZ;
            int blockX = Mth.floor((float)camX);
            int blockY = Mth.floor((float)camY);
            int blockZ = Mth.floor((float)camZ);
            Tesselator tesselator = Tesselator.getInstance();
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            cursor.set(blockX, blockY, blockZ);
            ClimateModel model = Climate.get((Level)level);
            long calendarTick = Calendars.get((LevelReader)level).getCalendarTicks();
            float climateRain = model.getRain(calendarTick);
            float climateRainfall = model.getRainfall((LevelReader)level, (BlockPos)cursor);
            float rainIntensity = WeatherHelpers.calculateRealRainIntensity(climateRain, climateRainfall);
            float currentTick = (float)ticks + partialTick;
            BufferBuilder buffer = null;
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            int blockRadius = Minecraft.useFancyGraphics() ? (int)Mth.map((float)rainIntensity, (float)0.0f, (float)1.0f, (float)5.0f, (float)15.0f) : 5;
            RenderSystem.depthMask((boolean)Minecraft.useShaderTransparency());
            RenderSystem.setShader(GameRenderer::getParticleShader);
            int stateFlag = -1;
            Vec2 wind = ClimateRenderCache.INSTANCE.getWind();
            float xAngleRain = (float)Math.PI * 2 / (360.0f / Mth.clampedMap((float)wind.x, (float)-0.4f, (float)0.4f, (float)-0.34906584f, (float)0.34906584f));
            float zAngleRain = (float)Math.PI * 2 / (360.0f / Mth.clampedMap((float)wind.y, (float)-0.4f, (float)0.4f, (float)-0.34906584f, (float)0.34906584f));
            float xAngleSnow = (float)Math.PI * 2 / (360.0f / Mth.clampedMap((float)wind.x, (float)-0.4f, (float)0.4f, (float)-0.5235988f, (float)0.5235988f));
            float zAngleSnow = (float)Math.PI * 2 / (360.0f / Mth.clampedMap((float)wind.y, (float)-0.4f, (float)0.4f, (float)-0.5235988f, (float)0.5235988f));
            float defaultXOffsetRain = (float)(Math.tan(xAngleRain * 57.295776f) * 10.0);
            float defaultZOffsetRain = (float)(Math.tan(zAngleRain * 57.295776f) * 10.0);
            float defaultXOffsetSnow = (float)(Math.tan(xAngleSnow * 57.295776f) * 10.0);
            float defaultZOffsetSnow = (float)(Math.tan(zAngleSnow * 57.295776f) * 10.0);
            for (int z = blockZ - blockRadius; z <= blockZ + blockRadius; ++z) {
                for (int x = blockX - blockRadius; x <= blockX + blockRadius; ++x) {
                    int rainSizeIndex = (z - blockZ + 16) * 32 + x - blockX + 16;
                    float rainSizeX = this.rainSizeX[rainSizeIndex] * 0.5f;
                    float rainSizeZ = this.rainSizeZ[rainSizeIndex] * 0.5f;
                    cursor.set((double)x, (double)camY, (double)z);
                    int yHeight = level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z);
                    int minY = blockY - blockRadius;
                    int maxY = blockY + blockRadius;
                    if (minY < yHeight) {
                        minY = yHeight;
                    }
                    if (maxY < yHeight) {
                        maxY = yHeight;
                    }
                    int y = Math.max(yHeight, blockY);
                    if (minY == maxY) continue;
                    RandomSource random = RandomSource.create((long)((long)(x * x) * 3121L + (long)x * 45238971L ^ (long)(z * z) * 418711L + (long)z * 13761L));
                    cursor.set(x, minY, z);
                    if (model.getTemperature((LevelReader)level, (BlockPos)cursor) > 0.0f) {
                        if (stateFlag != 0) {
                            if (stateFlag >= 0) {
                                BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
                            }
                            stateFlag = 0;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)RAIN_LOCATIONS[Mth.clamp((int)Mth.floor((float)(rainIntensity * 4.0f)), (int)0, (int)3)]);
                            buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                        }
                        int i3 = ticks & 0x1FFFF;
                        int j3 = x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0xFF;
                        float f2 = 3.0f + random.nextFloat();
                        float f3 = -((float)(i3 + j3) + partialTick) / 32.0f * f2;
                        float v = f3 % 32.0f;
                        double d2 = (double)x + 0.5 - (double)camX;
                        double d3 = (double)z + 0.5 - (double)camZ;
                        float f6 = (float)Math.sqrt(d2 * d2 + d3 * d3) / (float)blockRadius;
                        float alpha = Mth.clamp((float)((1.0f - f6 * f6) * 0.5f + 0.5f), (float)0.0f, (float)1.0f) * rainLevel;
                        float height = maxY - minY;
                        float xOffset = defaultXOffsetRain;
                        float zOffset = defaultZOffsetRain;
                        if (height != 10.0f) {
                            zOffset = (float)(Math.tan(zAngleRain * 57.295776f) * (double)height);
                            xOffset = (float)(Math.tan(xAngleRain * 57.295776f) * (double)height);
                        }
                        cursor.set(x, y, z);
                        int light = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)cursor);
                        Vector3f vert0 = new Vector3f((float)x - camX - rainSizeX + 0.5f, (float)maxY - camY, (float)z - camZ - rainSizeZ + 0.5f);
                        Vector3f vert1 = new Vector3f((float)x - camX + rainSizeX + 0.5f, (float)maxY - camY, (float)z - camZ + rainSizeZ + 0.5f);
                        Vector3f vert2 = new Vector3f((float)x - camX + rainSizeX + 0.5f, (float)minY - camY, (float)z - camZ + rainSizeZ + 0.5f);
                        Vector3f vert3 = new Vector3f((float)x - camX - rainSizeX + 0.5f, (float)minY - camY, (float)z - camZ - rainSizeZ + 0.5f);
                        vert0 = vert0.add(-xOffset / 2.0f, 0.0f, -zOffset / 2.0f);
                        vert1 = vert1.add(-xOffset / 2.0f, 0.0f, -zOffset / 2.0f);
                        vert2 = vert2.add(xOffset / 2.0f, 0.0f, zOffset / 2.0f);
                        vert3 = vert3.add(xOffset / 2.0f, 0.0f, zOffset / 2.0f);
                        buffer.addVertex(vert0).setUv(0.0f, (float)minY * 0.25f + v).setColor(1.0f, 1.0f, 1.0f, alpha).setLight(light);
                        buffer.addVertex(vert1).setUv(1.0f, (float)minY * 0.25f + v).setColor(1.0f, 1.0f, 1.0f, alpha).setLight(light);
                        buffer.addVertex(vert2).setUv(1.0f, (float)maxY * 0.25f + v).setColor(1.0f, 1.0f, 1.0f, alpha).setLight(light);
                        buffer.addVertex(vert3).setUv(0.0f, (float)maxY * 0.25f + v).setColor(1.0f, 1.0f, 1.0f, alpha).setLight(light);
                        continue;
                    }
                    if (stateFlag != 1) {
                        if (stateFlag >= 0) {
                            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
                        }
                        stateFlag = 1;
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SNOW_LOCATIONS[Mth.clamp((int)Mth.floor((float)(rainIntensity * 4.0f)), (int)0, (int)3)]);
                        buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                    }
                    float speed = Mth.clampedMap((float)wind.length(), (float)0.0f, (float)0.7f, (float)1.0f, (float)16.0f);
                    float f8 = -((float)(ticks & 0x1FF) + partialTick) / (512.0f / speed);
                    float f9 = (float)(random.nextDouble() + (double)currentTick * 0.01 * random.nextGaussian());
                    float f10 = (float)(random.nextDouble() + (double)currentTick * random.nextGaussian() * 0.001);
                    double d4 = (double)x + 0.5 - (double)camX;
                    double d5 = (double)z + 0.5 - (double)camZ;
                    float f11 = (float)Math.sqrt(d4 * d4 + d5 * d5) / (float)blockRadius;
                    float alpha = ((1.0f - f11 * f11) * 0.3f + 0.5f) * rainLevel;
                    cursor.set(x, y, z);
                    int light = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)cursor);
                    int lightV = light >> 16 & 0xFFFF;
                    int lightU = light & 0xFFFF;
                    int brightLightV = (lightV * 3 + 240) / 4;
                    int brightLightU = (lightU * 3 + 240) / 4;
                    float height = maxY - minY;
                    float xoffset = defaultXOffsetSnow;
                    float zoffset = defaultZOffsetSnow;
                    if (height != 10.0f) {
                        xoffset = (float)(Math.tan(xAngleSnow * 57.295776f) * (double)height);
                        zoffset = (float)(Math.tan(zAngleSnow * ((float)Math.PI / 180)) * (double)height);
                    }
                    cursor.set(x, y, z);
                    Vector3f vert0 = new Vector3f((float)x - camX - rainSizeX + 0.5f, (float)maxY - camY, (float)z - camZ - rainSizeZ + 0.5f);
                    Vector3f vert1 = new Vector3f((float)x - camX + rainSizeX + 0.5f, (float)maxY - camY, (float)z - camZ + rainSizeZ + 0.5f);
                    Vector3f vert2 = new Vector3f((float)x - camX + rainSizeX + 0.5f, (float)minY - camY, (float)z - camZ + rainSizeZ + 0.5f);
                    Vector3f vert3 = new Vector3f((float)x - camX - rainSizeX + 0.5f, (float)minY - camY, (float)z - camZ - rainSizeZ + 0.5f);
                    vert0 = vert0.add(-xoffset / 2.0f, 0.0f, -zoffset / 2.0f);
                    vert1 = vert1.add(-xoffset / 2.0f, 0.0f, -zoffset / 2.0f);
                    vert2 = vert2.add(xoffset / 2.0f, 0.0f, zoffset / 2.0f);
                    vert3 = vert3.add(xoffset / 2.0f, 0.0f, zoffset / 2.0f);
                    buffer.addVertex(vert0).setUv(0.0f + f9, (float)minY * 0.25f + f8 + f10).setColor(1.0f, 1.0f, 1.0f, alpha).setUv2(brightLightU, brightLightV);
                    buffer.addVertex(vert1).setUv(1.0f + f9, (float)minY * 0.25f + f8 + f10).setColor(1.0f, 1.0f, 1.0f, alpha).setUv2(brightLightU, brightLightV);
                    buffer.addVertex(vert2).setUv(1.0f + f9, (float)maxY * 0.25f + f8 + f10).setColor(1.0f, 1.0f, 1.0f, alpha).setUv2(brightLightU, brightLightV);
                    buffer.addVertex(vert3).setUv(0.0f + f9, (float)maxY * 0.25f + f8 + f10).setColor(1.0f, 1.0f, 1.0f, alpha).setUv2(brightLightU, brightLightV);
                }
            }
            if (stateFlag >= 0) {
                BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightTexture.turnOffLightLayer();
        }
        return true;
    }

    public boolean tickRain(ClientLevel level, int ticks, Camera camera) {
        boolean isSnowing;
        Minecraft minecraft = Minecraft.getInstance();
        float rainLevel = ClimateRenderCache.INSTANCE.getRainLevel(0.0f);
        boolean bl = isSnowing = ClimateRenderCache.INSTANCE.getTemperature() < 0.0f;
        if (rainLevel > 0.0f) {
            RandomSource random = RandomSource.create((long)((long)ticks * 312987231L));
            BlockPos cameraPos = BlockPos.containing((Position)camera.getPosition());
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            float rainIntensity = this.calculateRainIntensity((Level)level, cameraPos);
            float adjustedRainIntensity = rainLevel * Mth.clampedMap((float)rainIntensity, (float)0.0f, (float)0.3f, (float)0.0f, (float)1.0f) * (Minecraft.useFancyGraphics() ? 1.0f : 0.5f) * (minecraft.options.particles().get() == ParticleStatus.DECREASED ? 0.7f : 1.0f);
            int particleAmount = isSnowing ? 0 : (int)(100.0f * adjustedRainIntensity * adjustedRainIntensity);
            boolean addedAnyParticles = false;
            if (!isSnowing) {
                for (int n = 0; n < particleAmount; ++n) {
                    int dx = random.nextInt(21) - 10;
                    int dz = random.nextInt(21) - 10;
                    cursor.setWithOffset((Vec3i)cameraPos, dx, 0, dz);
                    cursor.setY(level.getHeight(Heightmap.Types.MOTION_BLOCKING, cursor.getX(), cursor.getZ()));
                    if (cursor.getY() <= level.getMinBuildHeight() || cursor.getY() > cameraPos.getY() + 10 || cursor.getY() < cameraPos.getY() - 10) continue;
                    cursor.move(Direction.DOWN);
                    addedAnyParticles = true;
                    if (minecraft.options.particles().get() == ParticleStatus.MINIMAL) break;
                    double offsetX = random.nextDouble();
                    double offsetZ = random.nextDouble();
                    BlockState state = level.getBlockState((BlockPos)cursor);
                    FluidState fluid = level.getFluidState((BlockPos)cursor);
                    VoxelShape shape = state.getBlock() instanceof IBlockRain ? Shapes.block() : state.getCollisionShape((BlockGetter)level, (BlockPos)cursor);
                    double offsetY = Math.max(shape.max(Direction.Axis.Y, offsetX, offsetZ), (double)fluid.getHeight((BlockGetter)level, (BlockPos)cursor));
                    SimpleParticleType options = !(fluid.is(FluidTags.LAVA) || Helpers.isBlock(state, TFCTags.Blocks.SMOKES_IN_RAIN) || CampfireBlock.isLitCampfire((BlockState)state) || Helpers.isBlock(state, (Block)TFCBlocks.FIREPIT.get()) && (Boolean)state.getValue((Property)FirepitBlock.LIT) != false || Helpers.isBlock(state, (Block)TFCBlocks.CHARCOAL_FORGE.get()) && (Integer)state.getValue((Property)CharcoalForgeBlock.HEAT) > 0) ? ParticleTypes.RAIN : ParticleTypes.SMOKE;
                    level.addParticle((ParticleOptions)options, (double)cursor.getX() + offsetX, (double)cursor.getY() + offsetY, (double)cursor.getZ() + offsetZ, 0.0, 0.0, 0.0);
                }
            }
            if (!isSnowing && addedAnyParticles && random.nextInt(3) < this.rainSoundTime++) {
                this.rainSoundTime = 0;
                float adjustedRainSoundIntensity = rainLevel * Mth.clampedMap((float)rainIntensity, (float)0.0f, (float)0.4f, (float)0.0f, (float)1.0f);
                if (cursor.getY() > cameraPos.getY() + 1 && level.getHeight(Heightmap.Types.MOTION_BLOCKING, cameraPos.getX(), cameraPos.getZ()) > Mth.floor((float)cameraPos.getY())) {
                    level.playLocalSound((BlockPos)cursor, SoundEvents.WEATHER_RAIN_ABOVE, SoundSource.WEATHER, adjustedRainSoundIntensity * 0.1f, 0.5f, false);
                } else {
                    level.playLocalSound((BlockPos)cursor, SoundEvents.WEATHER_RAIN, SoundSource.WEATHER, adjustedRainSoundIntensity * 0.2f, 1.0f, false);
                }
            }
        }
        return true;
    }

    private float calculateRainIntensity(Level level, BlockPos cameraPos) {
        ClimateModel model = Climate.get(level);
        long calendarTick = Calendars.get((LevelReader)level).getCalendarTicks();
        float climateRain = model.getRain(calendarTick);
        float climateRainfall = model.getRainfall((LevelReader)level, cameraPos);
        return WeatherHelpers.calculateRealRainIntensity(climateRain, climateRainfall);
    }

    private boolean doesMobEffectBlockSky(Camera camera) {
        LivingEntity entity;
        Entity entity2 = camera.getEntity();
        return entity2 instanceof LivingEntity && ((entity = (LivingEntity)entity2).hasEffect(MobEffects.BLINDNESS) || entity.hasEffect(MobEffects.DARKNESS));
    }
}

