/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.overworld;

import net.dries007.tfc.client.overworld.SkyPos;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public final class SolarCalculator {
    private static final double MOON_ORBIT_PHI = Math.tan(0.5143485265783966);

    public static int getSunBasedDayTime(int z, float hemisphereScale, float fractionOfYear, float fractionOfDay) {
        float zenith = SolarCalculator.getSunPosition(z, hemisphereScale, fractionOfYear, fractionOfDay).zenith();
        if ((double)fractionOfDay < 0.5) {
            if (zenith > 1.5707964f) {
                float minZenith = SolarCalculator.getSunPosition(z, hemisphereScale, fractionOfYear, 0.0f).zenith();
                return (int)Mth.clampedMap((float)zenith, (float)minZenith, (float)1.5707964f, (float)18000.0f, (float)24000.0f);
            }
            float maxZenith = SolarCalculator.getSunPosition(z, hemisphereScale, fractionOfYear, 0.5f).zenith();
            return (int)Mth.clampedMap((float)zenith, (float)1.5707964f, (float)maxZenith, (float)0.0f, (float)6000.0f);
        }
        if (zenith < 1.5707964f) {
            float maxZenith = SolarCalculator.getSunPosition(z, hemisphereScale, fractionOfYear, 0.5f).zenith();
            return (int)Mth.clampedMap((float)zenith, (float)maxZenith, (float)1.5707964f, (float)6000.0f, (float)12000.0f);
        }
        float minZenith = SolarCalculator.getSunPosition(z, hemisphereScale, fractionOfYear, 1.0f).zenith();
        return (int)Mth.clampedMap((float)zenith, (float)1.5707964f, (float)minZenith, (float)12000.0f, (float)18000.0f);
    }

    public static SkyPos getSunPosition(int z, float hemisphereScale, float fractionOfYear, float fractionOfDay) {
        double latitude = SolarCalculator.getLatitude(z, hemisphereScale);
        double declination = 0.40910518f * Mth.sin((float)((float)Math.PI * 2 * (0.7780822f + fractionOfYear)));
        double hourAngle = (float)Math.PI * 2 * (0.5f - fractionOfDay);
        double sinL = Math.sin(latitude);
        double cosL = SolarCalculator.cosFromSin(latitude, sinL);
        double sinD = Math.sin(declination);
        double cosD = SolarCalculator.cosFromSin(declination, sinD);
        double solarZenithAngle = Math.acos(Mth.clamp((double)(sinL * sinD + cosL * cosD * Math.cos(hourAngle)), (double)-1.0, (double)1.0));
        double sinZ = Math.sin(solarZenithAngle);
        double cosZ = SolarCalculator.cosFromSin(solarZenithAngle, sinZ);
        double absSolarAzimuthAngle = Math.acos(Mth.clamp((double)((sinD - cosZ * sinL) / (sinZ * cosL)), (double)-1.0, (double)1.0));
        double solarAzimuthAngle = hourAngle < 0.0 ? absSolarAzimuthAngle : 6.2831854820251465 - absSolarAzimuthAngle;
        return SkyPos.of(solarZenithAngle, solarAzimuthAngle);
    }

    public static float getLatitude(int z, float hemisphereScale) {
        return Helpers.triangle(-1.5707964f, 0.0f, 1.0f / (4.0f * hemisphereScale), (float)z - 0.5f * hemisphereScale);
    }

    public static boolean getInNorthernHemisphere(BlockPos pos, Level level) {
        return SolarCalculator.getInNorthernHemisphere(pos.getZ(), Climate.get(level).hemisphereScale());
    }

    public static boolean getInNorthernHemisphere(int z, float hemisphereScale) {
        if (hemisphereScale == 0.0f) {
            return true;
        }
        int adjustedZ = z - (int)(hemisphereScale / 2.0f);
        int poleToPoleDistance = (int)(hemisphereScale * 2.0f);
        int normalizedZ = Mth.positiveModulo((int)adjustedZ, (int)(poleToPoleDistance * 2));
        return normalizedZ > poleToPoleDistance;
    }

    public static int getMoonPhase(long calendarTick, long lunarOrbitTicks) {
        return (int)Mth.clampedMap((float)((float)((calendarTick + lunarOrbitTicks / 8L) % lunarOrbitTicks) / (float)lunarOrbitTicks), (float)0.0f, (float)1.0f, (float)0.0f, (float)7.0f);
    }

    public static SkyPos getMoonPosition(int z, float hemisphereScale, long calendarTick, long lunarOrbitTicks) {
        double lunarAzimuth = (float)Math.PI * 2 * (float)(calendarTick % lunarOrbitTicks) / (float)lunarOrbitTicks;
        double lunarZenith = 1.5707963705062866 - Math.atan2(Math.cos((float)Math.PI * 2 * (float)((double)calendarTick * 0.83 % (double)lunarOrbitTicks) / (float)lunarOrbitTicks) * MOON_ORBIT_PHI, 1.0);
        double observerZenith = 1.5707964f - SolarCalculator.getLatitude(z, hemisphereScale);
        double observerAzimuth = (float)Math.PI * 2 * (1.0f - ICalendar.getFractionOfDay(calendarTick));
        double deltaAzimuth = lunarAzimuth - observerAzimuth;
        double sinPhiD = Math.sin(deltaAzimuth);
        double cosPhiD = SolarCalculator.cosFromSin(deltaAzimuth, sinPhiD);
        double sinThetaP = Math.sin(observerZenith);
        double cosThetaP = SolarCalculator.cosFromSin(observerZenith, sinThetaP);
        double sinThetaM = Math.sin(lunarZenith);
        double cosThetaM = SolarCalculator.cosFromSin(lunarZenith, sinThetaM);
        double lunarX = cosPhiD * cosThetaP * sinThetaM - cosThetaM * sinThetaP;
        double lunarY = sinThetaM * sinPhiD;
        double lunarZ = cosThetaM * cosThetaP + cosPhiD * sinThetaM * sinThetaP;
        double relativeLunarZenith = Math.acos(lunarZ);
        double relativeLunarAzimuth = 3.1415927410125732 - Math.atan2(lunarY, lunarX);
        return SkyPos.of(relativeLunarZenith, relativeLunarAzimuth);
    }

    public static SkyPos getStarPosition(int z, float hemisphereScale, float fractionOfDay, float fractionOfYear) {
        double starZenith = 1.5707964f - SolarCalculator.getLatitude(z, hemisphereScale);
        double starAzimuth = (float)Math.PI * 2 * Mth.frac((float)(fractionOfYear + fractionOfDay + 0.5f));
        return SkyPos.of(starZenith, starAzimuth);
    }

    private static double cosFromSin(double angle, double sin) {
        return org.joml.Math.cosFromSin((double)sin, (double)angle);
    }

    private SolarCalculator() {
    }
}

