/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.overworld;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.dries007.tfc.client.overworld.LevelRendererExtension;
import net.dries007.tfc.client.overworld.Star;
import net.dries007.tfc.util.Helpers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class StarsReloadListener
extends SimplePreparableReloadListener<JsonElement> {
    private static final ResourceLocation ID = Helpers.identifier("stars.json");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();

    protected JsonElement prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        JsonElement jsonElement;
        block8: {
            BufferedReader reader = resourceManager.openAsReader(ID);
            try {
                jsonElement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException e) {
                    LOGGER.error("Could not load stars", e);
                    return JsonNull.INSTANCE;
                }
            }
            reader.close();
        }
        return jsonElement;
    }

    protected void apply(JsonElement object, ResourceManager resourceManager, ProfilerFiller profiler) {
        try {
            LevelRendererExtension.INSTANCE.updateStars((List)Star.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).getOrThrow(JsonParseException::new));
        }
        catch (JsonParseException e) {
            LOGGER.error("Could not parse stars.json", (Throwable)e);
        }
    }
}

