/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.particle;

import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.wood.TFCLeavesBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;

public class LeafParticle
extends TextureSheetParticle {
    private final float windMoveX;
    private final float windMoveZ;
    private final int xSignModifier;
    private final int zSignModifier;
    private final double xMod;
    private final double zMod;

    public LeafParticle(ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ, boolean tinted) {
        super(level, x, y, z);
        this.xSignModifier = this.random.nextBoolean() ? 1 : -1;
        this.zSignModifier = this.random.nextBoolean() ? 1 : -1;
        this.xMod = (this.random.nextFloat() - 0.5f) / 7.0f;
        this.zMod = (this.random.nextFloat() - 0.5f) / 7.0f;
        this.lifetime = 60 + this.random.nextInt(20);
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.scale(Mth.nextFloat((RandomSource)this.random, (float)1.8f, (float)2.6f));
        BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
        if (tinted) {
            BlockState state = level.getBlockState(pos);
            int color = Helpers.isBlock(state, TFCTags.Blocks.SEASONAL_LEAVES) ? TFCColors.getSeasonalFoliageColor(pos, 0, state.getBlock() instanceof TFCLeavesBlock ? ((TFCLeavesBlock)state.getBlock()).getAutumnIndex() : 0) : TFCColors.getFoliageColor(pos, 0);
            this.setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        }
        Vec2 wind = ClimateRenderCache.INSTANCE.getWind();
        float windStrength = wind.length();
        this.windMoveX = wind.x * windStrength * 0.4f;
        this.windMoveZ = wind.y * windStrength * 0.4f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        float swayWave = 0.03f * Mth.sin((float)((float)this.age / 12.5f));
        float rollWave = 0.1f * Mth.sin((float)((float)this.age / 12.5f));
        this.roll = rollWave * (float)this.xSignModifier;
        this.yd -= 0.001;
        this.move(this.xd, this.yd, this.zd);
        this.xd = (double)(swayWave * (float)this.xSignModifier) + this.xMod + (double)this.windMoveX;
        this.yd *= 0.96;
        this.zd = (double)(swayWave * (float)this.zSignModifier) + this.zMod + (double)this.windMoveZ;
        if (this.onGround) {
            this.alpha = (float)((double)this.alpha + 0.04);
            if (this.alpha >= 1.0f) {
                this.remove();
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public record Provider(SpriteSet set, boolean tinted) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LeafParticle particle = new LeafParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.tinted);
            particle.pickSprite(this.set);
            return particle;
        }
    }
}

